/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.shaders.FogShape;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.material.FogType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

@EventBusSubscriber(modid="tropicraft", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ScubaGogglesItem
extends ScubaArmorItem {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"tropicraft");
    private static final DeferredHolder<Attribute, Attribute> UNDERWATER_VISIBILITY = ATTRIBUTES.register("underwater_visibility", () -> new RangedAttribute(TropicraftLangKeys.SCUBA_VISIBILITY_STAT.key(), 0.0, -1.0, 1.0));
    private static final AttributeModifier VISIBILITY_BOOST = new AttributeModifier(Tropicraft.location("underwater.visibility"), 0.25, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private final Supplier<ItemAttributeModifiers> boostedModifiers = Suppliers.memoize(() -> {
        ItemAttributeModifiers inheritedModifiers = super.getDefaultAttributeModifiers();
        return inheritedModifiers.withModifierAdded(UNDERWATER_VISIBILITY, VISIBILITY_BOOST, EquipmentSlotGroup.HEAD);
    });

    public ScubaGogglesItem(ScubaType type, Item.Properties builder) {
        super(type, ArmorItem.Type.HELMET, builder);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderWaterFog(ViewportEvent.RenderFog event) {
        LocalPlayer player;
        Entity entity;
        if (event.getFogShape() == FogShape.CYLINDER) {
            return;
        }
        Camera camera = event.getCamera();
        if (camera.getFluidInCamera() == FogType.WATER && (entity = camera.getEntity()) instanceof LocalPlayer && (player = (LocalPlayer)entity).getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ScubaGogglesItem) {
            event.setFarPlaneDistance(event.getFarPlaneDistance() * 1.25f);
            event.setCanceled(true);
        }
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.boostedModifiers.get();
    }
}

