/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.network.message;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.block.tileentity.AirCompressorBlockEntity;

public record ClientboundAirCompressorInventoryPacket(BlockPos pos, ItemStack tank) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundAirCompressorInventoryPacket> TYPE = new CustomPacketPayload.Type(Tropicraft.location("air_compressor_inventory"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundAirCompressorInventoryPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ClientboundAirCompressorInventoryPacket::pos, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ClientboundAirCompressorInventoryPacket::tank, ClientboundAirCompressorInventoryPacket::new);

    public ClientboundAirCompressorInventoryPacket(AirCompressorBlockEntity airCompressor) {
        this(airCompressor.getBlockPos(), airCompressor.getTankStack());
    }

    public static void handle(ClientboundAirCompressorInventoryPacket packet, IPayloadContext ctx) {
        BlockEntity blockEntity;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (blockEntity = level.getBlockEntity(packet.pos)) instanceof AirCompressorBlockEntity) {
            AirCompressorBlockEntity compressor = (AirCompressorBlockEntity)blockEntity;
            if (!packet.tank.isEmpty()) {
                compressor.addTank(packet.tank);
            } else {
                compressor.ejectTank();
            }
        }
    }

    public CustomPacketPayload.Type<ClientboundAirCompressorInventoryPacket> type() {
        return TYPE;
    }
}

