/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras;

import com.lovetropics.extras.ExtraBlocks;
import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.ExtraLangKeys;
import com.lovetropics.extras.ExtrasConfig;
import com.lovetropics.extras.client.ClientPlayerSensorEffects;
import com.lovetropics.extras.client.command.NameTagModeCommand;
import com.lovetropics.extras.client.entity.model.RaveKoaModel;
import com.lovetropics.extras.client.particle.ExtraParticles;
import com.lovetropics.extras.collectible.CollectibleCommand;
import com.lovetropics.extras.command.GenerateCommand;
import com.lovetropics.extras.command.PoiCommand;
import com.lovetropics.extras.command.SetMaxPlayersCommand;
import com.lovetropics.extras.command.TpCommand;
import com.lovetropics.extras.command.WarpCommand;
import com.lovetropics.extras.data.attachment.ExtraAttachments;
import com.lovetropics.extras.data.spawnitems.SpawnItemsCommand;
import com.lovetropics.extras.effect.ExtraEffects;
import com.lovetropics.extras.entity.ExtraEntities;
import com.lovetropics.extras.item.ExtraItemProperties;
import com.lovetropics.extras.world_effect.WorldEffectCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.providers.ProviderType;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;

@Mod(value="ltextras")
public class LTExtras {
    public static final String MODID = "ltextras";
    private static final ResourceLocation TAB_ID = LTExtras.location("ltextras");
    public static final ResourceKey<CreativeModeTab> TAB_KEY = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)TAB_ID);
    @Nullable
    private static Registrate REGISTRATE = null;
    public static final Holder<Attribute> FRICTION = LTExtras.registrate().simple("friction", Registries.ATTRIBUTE, () -> new RangedAttribute("ltextras.friction", 1.0, 0.0, 1024.0).setSyncable(true));
    private static final Pattern QUALIFIER = Pattern.compile("-\\w+\\+\\d+");

    public static Registrate registrate() {
        if (REGISTRATE == null) {
            REGISTRATE = (Registrate)Registrate.create((String)MODID).defaultCreativeTab(TAB_KEY);
        }
        return REGISTRATE;
    }

    public LTExtras(IEventBus modBus, ModContainer container) {
        ExtraBlocks.init();
        ExtraItems.init();
        ExtraEntities.init();
        ExtraParticles.REGISTER.register(modBus);
        ExtraEffects.REGISTER.register(modBus);
        ExtraDataComponents.REGISTER.register(modBus);
        ExtraAttachments.REGISTER.register(modBus);
        NeoForge.EVENT_BUS.addListener(this::onRegisterCommands);
        NeoForge.EVENT_BUS.addListener(this::onRegisterClientCommands);
        modBus.addListener(this::onModifyAttributes);
        ExtraLangKeys.init(LTExtras.registrate());
        ((Registrate)LTExtras.registrate().addDataGenerator(ProviderType.LANG, p -> {
            p.add((MobEffect)ExtraEffects.FISH_EYE.get(), "Fish Eye");
            p.add("toast.collectible.title", "New Collectible!");
            p.add("toast.collectible.item", " + %s");
            p.add("spawnitems.set_not_restorable", "The spawn item set %s cannot be restored!");
            p.add("spawnitems.unknown_set", "Unknown spawn item set: %s");
            p.add("spawnitems.restored_successfully", "Items restored!");
            p.add("ltextras.friction", "Friction");
            TpCommand.addTranslations(p);
            WarpCommand.addTranslations(p);
        })).generic(TAB_ID.getPath(), Registries.CREATIVE_MODE_TAB, () -> CreativeModeTab.builder().title((Component)LTExtras.registrate().addLang("itemGroup", TAB_ID, "LTExtras")).icon(() -> ExtraBlocks.BUOY.asStack()).build()).build();
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ExtrasConfig.COMMON_CONFIG);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ExtrasConfig.CLIENT_CONFIG);
    }

    public static String getCompatVersion() {
        return LTExtras.getCompatVersion(((ModContainer)ModList.get().getModContainerById(MODID).orElseThrow(IllegalStateException::new)).getModInfo().getVersion().toString());
    }

    private static String getCompatVersion(String fullVersion) {
        return QUALIFIER.matcher(fullVersion).replaceAll("");
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CommandBuildContext buildContext = event.getBuildContext();
        SetMaxPlayersCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        GenerateCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        CollectibleCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
        SpawnItemsCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        TpCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        WorldEffectCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        WarpCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        PoiCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
    }

    private void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        NameTagModeCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    private void onModifyAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, FRICTION);
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @EventBusSubscriber(modid="ltextras", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ClientSetup {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            ExtraItemProperties.register();
        }

        @SubscribeEvent
        public static void registerItemColors(RegisterColorHandlersEvent.Item evt) {
            evt.getItemColors().register((stack, index) -> index == 0 ? 4159204 : -1, new ItemLike[]{(ItemLike)ExtraBlocks.WATER_BARRIER.get(), (ItemLike)ExtraBlocks.FAKE_WATER.get()});
            evt.getItemColors().register((stack, index) -> {
                BlockState blockstate = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
                return evt.getBlockColors().getColor(blockstate, null, null, index);
            }, new ItemLike[]{ExtraBlocks.SUBMERGED_LILY_PAD.asItem()});
            evt.getItemColors().register((stack, index) -> 9551190, new ItemLike[]{(ItemLike)ExtraBlocks.GRASS_GRASS.get()});
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(RaveKoaModel.LAYER_LOCATION, RaveKoaModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void registerGuiLayers(RegisterGuiLayersEvent event) {
            ClientPlayerSensorEffects.registerGuiLayers(event);
        }
    }
}

