/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.lovetropics.extras.ExtraBlocks;
import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.block.entity.JumpPadBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="ltextras")
public class JumpPadBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<JumpPadBlock> CODEC = JumpPadBlock.simpleCodec(JumpPadBlock::new);
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", direction -> direction != Direction.DOWN);
    public static final EnumProperty<Half> HALF = EnumProperty.create((String)"half", Half.class);
    private static final VoxelShape BOTTOM_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP_SHAPE = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public JumpPadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP)).setValue(HALF, (Comparable)Half.BOTTOM));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.DEBUG_STICK) && player.canUseGameMasterBlocks()) {
            if (!level.isClientSide()) {
                player.sendSystemMessage((Component)Component.literal((String)"Right-click with the debug stick at the desired jump target location"));
                stack.set((DataComponentType)ExtraDataComponents.JUMP_PAD.get(), (Object)pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity blockEntity;
        BlockPos jumpPadPos = (BlockPos)event.getItemStack().remove((DataComponentType)ExtraDataComponents.JUMP_PAD.get());
        if (jumpPadPos == null) {
            return;
        }
        Level level = event.getLevel();
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(jumpPadPos)) instanceof JumpPadBlockEntity) {
            JumpPadBlockEntity jumpPad = (JumpPadBlockEntity)blockEntity;
            jumpPad.updateTarget(event.getHitVec().getLocation());
            event.getEntity().sendSystemMessage((Component)Component.literal((String)"Set jump target"));
        }
        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        BlockEntity blockEntity;
        BlockPos jumpPadPos = (BlockPos)event.getItemStack().remove((DataComponentType)ExtraDataComponents.JUMP_PAD.get());
        if (jumpPadPos == null) {
            return;
        }
        Level level = event.getLevel();
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(jumpPadPos)) instanceof JumpPadBlockEntity) {
            JumpPadBlockEntity jumpPad = (JumpPadBlockEntity)blockEntity;
            jumpPad.updateTarget(event.getEntity().position());
            event.getEntity().sendSystemMessage((Component)Component.literal((String)"Set jump target"));
        }
        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getSide().isClient()));
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (level.isClientSide()) {
            return;
        }
        if (!entity.onGround() || entity.getKnownMovement().lengthSqr() > 1.0E-4) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof JumpPadBlockEntity) {
            JumpPadBlockEntity jumpPad = (JumpPadBlockEntity)blockEntity;
            Vec3 velocity = jumpPad.getLaunchVelocity();
            if (velocity.lengthSqr() < 0.01) {
                return;
            }
            level.playSound(null, entity, SoundEvents.BREEZE_JUMP, SoundSource.BLOCKS, 1.0f, 1.0f);
            entity.setDeltaMovement(velocity);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        boolean onTopHalf = context.getClickLocation().y - (double)pos.getY() > 0.5;
        return (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)(clickedFace == Direction.DOWN || clickedFace != Direction.UP && onTopHalf ? Half.TOP : Half.BOTTOM));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Half)state.getValue(HALF)) {
            default -> throw new MatchException(null, null);
            case Half.BOTTOM -> BOTTOM_SHAPE;
            case Half.TOP -> TOP_SHAPE;
        };
    }

    protected MapCodec<JumpPadBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new JumpPadBlockEntity((BlockEntityType)ExtraBlocks.JUMP_PAD_ENTITY.get(), pos, state);
    }
}

