/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class PianguasBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final BooleanProperty UP = PipeBlock.UP;
    private static final BooleanProperty DOWN = PipeBlock.DOWN;
    private static final BooleanProperty NORTH = PipeBlock.NORTH;
    private static final BooleanProperty EAST = PipeBlock.EAST;
    private static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    private static final BooleanProperty WEST = PipeBlock.WEST;
    public static final Map<Direction, BooleanProperty> ATTACHMENTS = PipeBlock.PROPERTY_BY_DIRECTION;
    private static final VoxelShape UP_SHAPE = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Direction[] DIRECTIONS = Direction.values();
    private final Map<BlockState, VoxelShape> stateToShape;

    public PianguasBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.stateToShape = this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), PianguasBlock::getShapeForState));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.stateToShape.get(state);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return PianguasBlock.hasAttachments(PianguasBlock.removeInvalidAttachments(state, (BlockGetter)world, pos));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.getLevel();
        BlockState currentState = world.getBlockState(pos = context.getClickedPos());
        boolean extend = currentState.is((Block)this);
        BlockState placementState = extend ? currentState : this.defaultBlockState();
        Fluid fluid = world.getFluidState(pos).getType();
        placementState = (BlockState)placementState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.WATER));
        for (Direction direction : context.getNearestLookingDirections()) {
            boolean replacing;
            BooleanProperty property = PianguasBlock.getPropertyFor(direction);
            boolean bl = replacing = extend && (Boolean)currentState.getValue((Property)property) != false;
            if (replacing || !PianguasBlock.canAttachTo((BlockGetter)world, pos.relative(direction), direction)) continue;
            return (BlockState)placementState.setValue((Property)property, (Comparable)Boolean.valueOf(true));
        }
        return extend ? placementState : null;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState adjacentState, LevelAccessor world, BlockPos currentPos, BlockPos adjacentPos) {
        BlockState newState = PianguasBlock.removeInvalidAttachments(state, (BlockGetter)world, currentPos);
        if (!PianguasBlock.hasAttachments(newState)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return newState;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        BlockState currentState = context.getLevel().getBlockState(context.getClickedPos());
        if (currentState.is((Block)this)) {
            return PianguasBlock.getAttachmentCount(currentState) < ATTACHMENTS.size();
        }
        return super.canBeReplaced(state, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)));
            default -> state;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            default -> super.mirror(state, mirror);
        };
    }

    public static boolean canAttachTo(BlockGetter world, BlockPos attachPos, Direction direction) {
        BlockState attachState = world.getBlockState(attachPos);
        VoxelShape attachShape = attachState.getCollisionShape(world, attachPos);
        return Block.isFaceFull((VoxelShape)attachShape, (Direction)direction.getOpposite());
    }

    private static BlockState removeInvalidAttachments(BlockState state, BlockGetter world, BlockPos pos) {
        for (Direction direction : DIRECTIONS) {
            BlockPos attachPos;
            BooleanProperty property = PianguasBlock.getPropertyFor(direction);
            if (!((Boolean)state.getValue((Property)property)).booleanValue() || PianguasBlock.canAttachTo(world, attachPos = pos.relative(direction), direction)) continue;
            state = (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    private static VoxelShape getShapeForState(BlockState state) {
        VoxelShape shape = Shapes.empty();
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            shape = UP_SHAPE;
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            shape = DOWN_SHAPE;
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        return shape;
    }

    private static boolean hasAttachments(BlockState state) {
        return PianguasBlock.getAttachmentCount(state) > 0;
    }

    private static int getAttachmentCount(BlockState state) {
        int count = 0;
        for (BooleanProperty property : ATTACHMENTS.values()) {
            if (!((Boolean)state.getValue((Property)property)).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    private static BooleanProperty getPropertyFor(Direction side) {
        return ATTACHMENTS.get(side);
    }
}

