/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class TrajectorySolver {
    public static final TrajectorySolver STANDARD = new TrajectorySolver(0.08, 0.91, 0.98);
    private static final double SOLVER_STEP = 0.01;
    private static final double GROUND_FRICTION = 0.6;
    private final double gravity;
    private final double frictionX;
    private final double frictionY;

    public TrajectorySolver(double gravity, double frictionX, double frictionY) {
        this.gravity = gravity;
        this.frictionX = frictionX;
        this.frictionY = frictionY;
    }

    public double solveVelocity(double initialHeight, double theta, double distance, boolean startOnGround, double maxVelocity) {
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        return (double)Mth.binarySearch((int)0, (int)Mth.ceil((double)(maxVelocity / 0.01)), index -> {
            double velocity = (double)index * 0.01;
            double simulatedDistance = this.simulateDistance(initialHeight, cos * velocity, sin * velocity, startOnGround);
            return distance <= simulatedDistance;
        }) * 0.01;
    }

    public Vec3 solveVelocity(Vec3 origin, Vec3 target, double theta, boolean startOnGround, double maxVelocity) {
        double deltaX = target.x - origin.x;
        double deltaZ = target.z - origin.z;
        double distance = Mth.length((double)deltaX, (double)deltaZ);
        double initialY = origin.y - target.y;
        double magnitude = this.solveVelocity(initialY, theta, distance, startOnGround, maxVelocity);
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        return new Vec3(magnitude * deltaX / distance * cos, magnitude * sin, magnitude * deltaZ / distance * cos);
    }

    private double simulateDistance(double initialY, double velocityX, double velocityY, boolean onGroundInFirstTick) {
        double x = 0.0;
        double y = initialY;
        int tick = 0;
        do {
            x += velocityX;
            double stepFrictionX = tick == 0 && onGroundInFirstTick ? 0.6 * this.frictionX : this.frictionX;
            velocityX *= stepFrictionX;
            velocityY = (velocityY - this.gravity) * this.frictionY;
            ++tick;
        } while ((y += velocityY) > 0.0 || velocityY > 0.0);
        return x;
    }
}

