/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block.entity;

import com.lovetropics.extras.entity.ExtendedCreatureEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MobControllerBlockEntity
extends BlockEntity {
    public boolean loadState = true;
    public final List<UUID> uuids = new ArrayList<UUID>();
    public final Map<UUID, EntityType<?>> types = new HashMap();
    public final Map<UUID, Vec3> positions = new HashMap<UUID, Vec3>();

    public MobControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ListTag mobUuids = tag.getList("Mobs", 10);
        this.uuids.clear();
        for (Tag mobNbt : mobUuids) {
            CompoundTag compoundNBT = (CompoundTag)mobNbt;
            UUID uuid = compoundNBT.getUUID("UUID");
            ResourceLocation type = ResourceLocation.parse((String)compoundNBT.getString("Type"));
            ListTag pos = compoundNBT.getList("Pos", 6);
            registries.lookupOrThrow(Registries.ENTITY_TYPE).get(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)type)).ifPresent(entityType -> {
                this.uuids.add(uuid);
                this.types.put(uuid, (EntityType)entityType.value());
                this.positions.put(uuid, new Vec3(pos.getDouble(0), pos.getDouble(1), pos.getDouble(2)));
            });
        }
        this.loadState = tag.getBoolean("LoadState");
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        ListTag mobs = new ListTag();
        for (UUID uuid : this.uuids) {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.putUUID("UUID", uuid);
            compoundNBT.putString("Type", EntityType.getKey(this.types.get(uuid)).toString());
            Vec3 pos = this.positions.get(uuid);
            compoundNBT.put("Pos", (Tag)this.newDoubleNBTList(pos.x, pos.y, pos.z));
            mobs.add((Object)compoundNBT);
        }
        compound.put("Mobs", (Tag)mobs);
        compound.putBoolean("LoadState", this.loadState);
    }

    protected ListTag newDoubleNBTList(double ... numbers) {
        ListTag listnbt = new ListTag();
        for (double d0 : numbers) {
            listnbt.add((Object)DoubleTag.valueOf((double)d0));
        }
        return listnbt;
    }

    public void addEntity(Entity entity) {
        if (entity instanceof ExtendedCreatureEntity) {
            ExtendedCreatureEntity ex = (ExtendedCreatureEntity)entity;
            ex.linkToBlockEntity(this);
            UUID uuid = entity.getUUID();
            this.uuids.add(uuid);
            this.types.put(uuid, entity.getType());
            this.positions.put(uuid, entity.position());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MobControllerBlockEntity controller) {
        block6: {
            Player player;
            ServerLevel serverLevel;
            block7: {
                if (!(level instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                long ticks = level.getGameTime();
                if (controller.loadState && ticks % 5L == 0L) {
                    for (UUID uuid : controller.uuids) {
                        Entity entity = serverLevel.getEntity(uuid);
                        if (entity == null) continue;
                        controller.positions.put(uuid, entity.position());
                    }
                }
                if (ticks % 20L != 0L) break block6;
                player = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 32.0, EntitySelector.NO_SPECTATORS);
                if (!controller.loadState) break block7;
                if (player != null) break block6;
                controller.loadState = false;
                for (UUID uuid : controller.uuids) {
                    Entity entity = serverLevel.getEntity(uuid);
                    if (entity == null) continue;
                    entity.discard();
                }
                break block6;
            }
            if (player != null) {
                controller.loadState = true;
                for (UUID uuid : controller.uuids) {
                    Entity entity = controller.types.get(uuid).create((Level)serverLevel);
                    Vec3 mobPos = controller.positions.get(uuid);
                    if (entity == null) continue;
                    entity.moveTo(mobPos.x(), mobPos.y(), mobPos.z(), 0.0f, 0.0f);
                    entity.setUUID(uuid);
                    level.addFreshEntity(entity);
                    if (entity instanceof Mob) {
                        ((Mob)entity).finalizeSpawn((ServerLevelAccessor)serverLevel, level.getCurrentDifficultyAt(pos), MobSpawnType.MOB_SUMMONED, null);
                    }
                    if (!(entity instanceof ExtendedCreatureEntity)) continue;
                    ((ExtendedCreatureEntity)entity).linkToBlockEntity(controller);
                }
            }
        }
    }
}

