/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.lovetropics.extras.data.packcontrol.PackControl;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.neoforged.fml.loading.FMLLoader;
import org.slf4j.Logger;

public class ClientPackControl {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Path STATE_PATH = FMLLoader.getGamePath().resolve("config/client_pack_control.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static CompletableFuture<PackControl.State> stateFuture = CompletableFuture.supplyAsync(ClientPackControl::readState).exceptionally(throwable -> {
        LOGGER.error("Failed to read pack control state", throwable);
        return PackControl.State.DEFAULT;
    });

    public static void updatePacks(PackControl.State state) {
        PackControl.State oldState = ClientPackControl.state();
        if (oldState.equals(state)) {
            return;
        }
        ClientPackControl.handleStateChange(Minecraft.getInstance(), oldState, state);
        stateFuture = CompletableFuture.completedFuture(state);
        Util.ioPool().submit(() -> ClientPackControl.storeState(state));
    }

    private static void handleStateChange(Minecraft minecraft, PackControl.State oldState, PackControl.State newState) {
        PackRepository packRepository = minecraft.getResourcePackRepository();
        Sets.SetView newlyEnabled = Sets.difference(newState.enabled(), oldState.enabled());
        Sets.SetView newlyDisabled = Sets.difference(oldState.enabled(), newState.enabled());
        newlyEnabled.forEach(arg_0 -> ((PackRepository)packRepository).addPack(arg_0));
        newlyDisabled.forEach(arg_0 -> ((PackRepository)packRepository).removePack(arg_0));
        minecraft.options.updateResourcePacks(packRepository);
    }

    private static PackControl.State readState() {
        PackControl.State state;
        block9: {
            if (!Files.exists(STATE_PATH, new LinkOption[0])) {
                return PackControl.State.DEFAULT;
            }
            BufferedReader reader = Files.newBufferedReader(STATE_PATH);
            try {
                state = (PackControl.State)PackControl.State.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            }
            reader.close();
        }
        return state;
    }

    private static void storeState(PackControl.State state) {
        try (BufferedWriter writer = Files.newBufferedWriter(STATE_PATH, new OpenOption[0]);){
            JsonElement json = (JsonElement)PackControl.State.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)state).getOrThrow();
            GSON.toJson(json, (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to write pack control state", (Throwable)e);
        }
    }

    public static PackControl.State state() {
        return stateFuture.join();
    }

    public static Collection<Pack> removeHidden(Collection<Pack> packs, PackRepository repository) {
        PackControl.State state = ClientPackControl.state();
        if (state.hidden().isEmpty()) {
            return packs;
        }
        ArrayList<Pack> newPacks = new ArrayList<Pack>(packs);
        Collection selectedIds = repository.getSelectedIds();
        if (newPacks.removeIf(pack -> {
            String id = pack.getId();
            return state.hidden().contains(id) && !selectedIds.contains(id);
        })) {
            return newPacks;
        }
        return packs;
    }
}

