/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client;

import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.collectible.Collectible;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CollectibleToast
implements Toast {
    private static final Component TITLE = Component.translatable((String)"toast.collectible.title");
    private static final long VISIBILITY_TIME_MS = 3000L;
    private static final int WIDTH = 160;
    private static final int HEIGHT = 32;
    private static final ResourceLocation SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/recipe");
    private final ItemStack stack;
    private final Component name;
    private final Minecraft minecraft = Minecraft.getInstance();

    public CollectibleToast(Holder<Collectible> collectible) {
        this.stack = Collectible.createItemStack(collectible, Util.NIL_UUID);
        this.name = Component.empty().withStyle(ChatFormatting.DARK_RED).append(this.stack.getHoverName());
    }

    public Toast.Visibility render(GuiGraphics graphics, ToastComponent component, long time) {
        graphics.blitSprite(SPRITE, 0, 0, 160, 32);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 100.0f);
        graphics.renderFakeItem(new ItemStack((ItemLike)ExtraItems.COLLECTIBLE_BASKET.asItem()), 11, 12);
        graphics.pose().popPose();
        graphics.renderFakeItem(this.stack, 5, 4);
        Font font = this.minecraft.font;
        int textLeft = 30;
        graphics.drawString(font, TITLE, 30, 7, -16777216, false);
        graphics.drawString(font, (Component)Component.translatable((String)"toast.collectible.item", (Object[])new Object[]{this.name}), 30, 18, -16777216, false);
        return time < 3000L ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    public int width() {
        return 160;
    }

    public int height() {
        return 32;
    }
}

