/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.entity;

import com.lovetropics.extras.entity.vfx.PartyBeamEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PartyBeamRenderer
extends EntityRenderer<PartyBeamEntity> {
    private static final ResourceLocation END_CRYSTAL_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/end_crystal/end_crystal.png");
    private static final RenderType BEAM = RenderType.entitySmoothCutout((ResourceLocation)EnderDragonRenderer.CRYSTAL_BEAM_LOCATION);
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)END_CRYSTAL_LOCATION);
    private static final float SIN_45 = Mth.sin((float)0.7853982f);
    private final ModelPart cube;
    private final ModelPart glass;
    private final ModelPart base;

    public PartyBeamRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        ModelPart root = context.bakeLayer(ModelLayers.END_CRYSTAL);
        this.glass = root.getChild("glass");
        this.cube = root.getChild("cube");
        this.base = root.getChild("base");
    }

    public void render(PartyBeamEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        float offsetY = PartyBeamRenderer.getY(entity, partialTicks);
        float time = ((float)entity.time + partialTicks) * 3.0f;
        VertexConsumer consumer = bufferSource.getBuffer(RENDER_TYPE);
        poseStack.pushPose();
        poseStack.scale(2.0f, 2.0f, 2.0f);
        poseStack.translate(0.0f, -0.5f, 0.0f);
        if (entity.showsBottom()) {
            this.base.render(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(time));
        poseStack.translate(0.0f, 1.5f + offsetY / 2.0f, 0.0f);
        poseStack.mulPose(new Quaternionf().rotateAxis(1.0471976f, (Vector3fc)new Vector3f(SIN_45, 0.0f, SIN_45)));
        this.glass.render(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.scale(0.875f, 0.875f, 0.875f);
        poseStack.mulPose(new Quaternionf().rotateAxis(1.0471976f, (Vector3fc)new Vector3f(SIN_45, 0.0f, SIN_45)));
        poseStack.mulPose(Axis.YP.rotationDegrees(time));
        this.glass.render(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.scale(0.875f, 0.875f, 0.875f);
        poseStack.mulPose(new Quaternionf().rotateAxis(1.0471976f, (Vector3fc)new Vector3f(SIN_45, 0.0f, SIN_45)));
        poseStack.mulPose(Axis.YP.rotationDegrees(time));
        this.cube.render(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        poseStack.popPose();
        BlockPos target = entity.getBeamTarget();
        if (target != null) {
            float targetX = (float)target.getX() + 0.5f;
            float targetY = (float)target.getY() + 0.5f;
            float targetZ = (float)target.getZ() + 0.5f;
            float deltaX = (float)((double)targetX - entity.getX());
            float deltaY = (float)((double)targetY - entity.getY());
            float deltaZ = (float)((double)targetZ - entity.getZ());
            poseStack.translate(deltaX, deltaY, deltaZ);
            this.renderCrystalBeams(entity, -deltaX, -deltaY + offsetY, -deltaZ, partialTicks, entity.time, poseStack, bufferSource, packedLight);
        }
        super.render((Entity)entity, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public void renderCrystalBeams(PartyBeamEntity entity, float deltaX, float deltaY, float deltaZ, float partialTicks, int time, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float lengthXz = Mth.sqrt((float)(deltaX * deltaX + deltaZ * deltaZ));
        float length = Mth.sqrt((float)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        poseStack.pushPose();
        poseStack.translate(0.0f, 2.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotation((float)(-Math.atan2(deltaZ, deltaX)) - 1.5707964f));
        poseStack.mulPose(Axis.XP.rotation((float)(-Math.atan2(lengthXz, deltaY)) - 1.5707964f));
        VertexConsumer consumer = bufferSource.getBuffer(BEAM);
        float startTextureOffset = -((float)time + partialTicks) * 0.01f;
        float endTextureOffset = length / 32.0f - ((float)time + partialTicks) * 0.01f;
        float lastX = 0.0f;
        float lastY = 0.75f;
        float lastProgress = 0.0f;
        PoseStack.Pose pose = poseStack.last();
        for (int i = 1; i <= 8; ++i) {
            float x = Mth.sin((float)((float)i * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float y = Mth.cos((float)((float)i * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float progress = (float)i / 8.0f;
            Vector3f color = entity.getColor();
            int packedColor = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)color.x, (float)color.y, (float)color.z);
            consumer.addVertex(pose, lastX * 0.2f, lastY * 0.2f, 0.0f).setColor(-16777216).setUv(lastProgress, startTextureOffset).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, -1.0f, 0.0f);
            consumer.addVertex(pose, lastX, lastY, length).setColor(packedColor).setUv(lastProgress, endTextureOffset).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, -1.0f, 0.0f);
            consumer.addVertex(pose, x, y, length).setColor(packedColor).setUv(progress, endTextureOffset).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, -1.0f, 0.0f);
            consumer.addVertex(pose, x * 0.2f, y * 0.2f, 0.0f).setColor(-16777216).setUv(progress, startTextureOffset).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, -1.0f, 0.0f);
            lastX = x;
            lastY = y;
            lastProgress = progress;
        }
        poseStack.popPose();
    }

    private static float getY(PartyBeamEntity entity, float partialTicks) {
        float time = (float)entity.time + partialTicks;
        float y = Mth.sin((float)(time * 0.2f)) / 2.0f + 0.5f;
        y = (y * y + y) * 0.4f;
        return y - 1.4f;
    }

    public ResourceLocation getTextureLocation(PartyBeamEntity entity) {
        return END_CRYSTAL_LOCATION;
    }

    public boolean shouldRender(PartyBeamEntity entity, Frustum frustum, double cameraX, double cameraY, double cameraZ) {
        return super.shouldRender((Entity)entity, frustum, cameraX, cameraY, cameraZ) || entity.getBeamTarget() != null;
    }
}

