/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.particle;

import com.lovetropics.extras.client.particle.ExtraParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

@EventBusSubscriber(modid="ltextras", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class CheckpointParticle
extends TextureSheetParticle {
    CheckpointParticle(ClientLevel world, double x, double y, double z, ItemLike item) {
        super(world, x, y, z);
        this.setSprite(ExtraParticles.getItemSprite(world, new ItemStack(item)));
        this.gravity = 0.0f;
        this.lifetime = 80;
        this.hasPhysics = false;
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        Minecraft.getInstance().particleEngine.register((ParticleType)ExtraParticles.CHECKPOINT.get(), (ParticleProvider)new Factory());
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    public float getQuadSize(float scaleFactor) {
        return 0.5f;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new CheckpointParticle(world, x, y, z, (ItemLike)Blocks.STRUCTURE_VOID.asItem());
        }
    }
}

