/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.particle;

import com.lovetropics.extras.client.particle.ExtraParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

@EventBusSubscriber(modid="ltextras", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class EmittedParticle
extends TextureSheetParticle {
    EmittedParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites) {
        super(world, x, y, z);
        float f;
        this.lifetime = 80;
        this.gravity = 0.5f;
        this.yd = 0.75;
        this.xd = (Math.random() - Math.random()) * 0.05;
        this.zd = (Math.random() - Math.random()) * 0.05;
        this.setSize(0.5f, 0.5f);
        this.rCol = f = (float)(Math.random() * (double)0.3f + (double)0.6f);
        this.gCol = f;
        this.bCol = f;
        this.pickSprite(sprites);
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        Minecraft.getInstance().particleEngine.register((ParticleType)ExtraParticles.EMITTED_PARTICLE.get(), Factory::new);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new EmittedParticle(pLevel, pX, pY, pZ, this.sprites);
        }
    }
}

