/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.particle;

import com.lovetropics.extras.client.particle.ExtraParticles;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="ltextras", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class WaterBarrierParticle
extends TextureSheetParticle {
    WaterBarrierParticle(ClientLevel world, double x, double y, double z, ItemLike item) {
        super(world, x, y, z);
        this.setSprite(ExtraParticles.getItemSprite(world, new ItemStack(item)));
        this.gravity = 0.0f;
        this.lifetime = 80;
        this.hasPhysics = false;
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        Minecraft.getInstance().particleEngine.register((ParticleType)ExtraParticles.WATER_BARRIER.get(), (ParticleProvider)new Factory());
    }

    public ParticleRenderType getRenderType() {
        return RenderType.INSTANCE;
    }

    public float getQuadSize(float scaleFactor) {
        return 0.5f;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new WaterBarrierParticle(world, x, y, z, (ItemLike)Blocks.BARRIER.asItem());
        }
    }

    public static class RenderType
    implements ParticleRenderType {
        public static final RenderType INSTANCE = new RenderType();

        private RenderType() {
        }

        @Nullable
        public BufferBuilder begin(Tesselator tess, TextureManager pTextureManager) {
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
            return tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }
    }
}

