/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.screen.map;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.client.map.ClientMapManager;
import com.lovetropics.extras.client.map.ClientPoi;
import com.lovetropics.extras.data.poi.PoiConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

class PoiButton
extends AbstractButton {
    private static final int ICON_SIZE = 16;
    private static final int HALF_ICON_SIZE = 8;
    private static final int BORDER_SIZE = 3;
    private static final int SIZE = 22;
    private static final int TOOLTIP_HEIGHT = 18;
    private static final int HOVER_ANIMATION_LENGTH = 8;
    private static final ResourceLocation TOOLTIP_SPRITE = LTExtras.location("widget/poi_tooltip");
    private static final ResourceLocation BACKGROUND_SPRITE = LTExtras.location("widget/poi_background");
    private static final ResourceLocation TITLE_BOX_SPRITE = ResourceLocation.withDefaultNamespace((String)"advancements/title_box");
    private static final int SELECTED_Z_OFFSET = 500;
    private final ClientPoi poi;
    private final Font font;
    private final Runnable action;
    private int lastFocusAnimation;
    private int focusAnimation;

    private PoiButton(Font font, int x, int y, Component message, ClientPoi poi, Runnable action) {
        super(x, y, 22, 22, message);
        this.poi = poi;
        this.font = font;
        this.action = action;
    }

    public static PoiButton create(Font font, int x, int y, ClientPoi poi, Runnable action) {
        Component description = poi.description();
        return new PoiButton(font, x - 11, y - 11, description, poi, action);
    }

    public void tick() {
        this.lastFocusAnimation = this.focusAnimation;
        boolean focused = this.isHoveredOrFocused();
        if (focused && this.focusAnimation < 8) {
            ++this.focusAnimation;
        } else if (!focused && this.focusAnimation > 0) {
            --this.focusAnimation;
        }
    }

    /*
     * Loose catch block
     */
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        block12: {
            int textTop;
            float animation = Mth.lerp((float)partialTicks, (float)this.lastFocusAnimation, (float)this.focusAnimation) / 8.0f;
            boolean isSelected = (animation = (float)(1.0 - Math.pow(1.0 - (double)animation, 5.0))) > 1.0E-5f;
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, isSelected ? 500.0f : 0.0f);
            if (isSelected) {
                int tooltipWidth = Mth.floor((float)((float)(this.font.width((FormattedText)this.getMessage()) + 6) * animation));
                int tooltipHeight = 18;
                this.setWidth(22 + tooltipWidth);
                graphics.blitSprite(TOOLTIP_SPRITE, this.getX(), this.getY() + (this.getHeight() - 18) / 2, this.getWidth(), 18);
                graphics.blitSprite(TITLE_BOX_SPRITE, this.getX(), this.getY() - 3, 22, 28);
                graphics.enableScissor(this.getX() + 3, this.getY() + 3, this.getX() + this.getWidth() - 3, this.getY() + this.getHeight() - 3);
                int textLeft = this.getX() + 22 + 3 - 1;
                int n = this.getY();
                int n2 = this.getHeight();
                Objects.requireNonNull(this.font);
                textTop = n + (n2 - 9) / 2 + 1;
                graphics.drawString(this.font, this.getMessage(), textLeft, textTop, -1);
                graphics.disableScissor();
            } else {
                this.setWidth(22);
            }
            int iconX = this.getX() + 3;
            int iconY = this.getY() + 3;
            if (!isSelected) {
                RenderSystem.enableBlend();
                graphics.blitSprite(BACKGROUND_SPRITE, iconX - 1, iconY - 1, 18, 18);
                RenderSystem.disableBlend();
            }
            PoiConfig.Icon icon = this.poi.icon();
            Objects.requireNonNull(icon);
            PoiConfig.Icon textLeft = icon;
            textTop = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PoiConfig.ItemIcon.class, PoiConfig.TextureIcon.class}, (Object)textLeft, textTop)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    PoiConfig.TextureIcon textureIcon;
                    PoiConfig.ItemIcon itemIcon = (PoiConfig.ItemIcon)textLeft;
                    PoiConfig.TextureIcon item = textureIcon = itemIcon.item();
                    graphics.renderFakeItem((ItemStack)item, iconX, iconY);
                    break;
                }
                case 1: {
                    ResourceLocation resourceLocation;
                    PoiConfig.TextureIcon textureIcon = (PoiConfig.TextureIcon)textLeft;
                    ResourceLocation texture = resourceLocation = textureIcon.texture();
                    graphics.blit(texture, iconX, iconY, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                }
            }
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 100.0f);
            List<UUID> faces = this.poi.faces();
            if (!faces.isEmpty()) {
                int faceFactor = faces.size() > 2 ? 2 : 1;
                for (int i = 0; i < faces.size(); ++i) {
                    ResourceLocation face = ClientMapManager.getFace(faces.get(i));
                    PlayerFaceRenderer.draw((GuiGraphics)graphics, (ResourceLocation)face, (int)(this.getX() + 3 + i * 8 / faceFactor + i), (int)(this.getY() + 16), (int)(8 / faceFactor));
                }
            }
            break block12;
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        graphics.pose().popPose();
        graphics.pose().popPose();
    }

    public void onPress() {
        this.action.run();
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }
}

