/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.screen.map;

import com.lovetropics.extras.client.map.ClientPoi;
import com.lovetropics.extras.client.screen.map.PoiButton;
import com.lovetropics.extras.data.poi.MapConfig;
import com.lovetropics.extras.data.poi.PoiConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;

public class TropicalMapScreen
extends Screen {
    private final Player player;
    private final List<PoiButton> poiButtons = new ArrayList<PoiButton>();
    private final MapConfig map;
    private final List<ClientPoi> pois;

    public TropicalMapScreen(Player player, MapConfig map, List<ClientPoi> pois) {
        super(map.description());
        this.player = player;
        this.map = map;
        this.pois = pois;
    }

    protected void init() {
        super.init();
        this.poiButtons.clear();
        int xOffset = this.width / 2 - 128;
        int yOffset = this.height / 2 - 128;
        for (ClientPoi poi : this.pois) {
            int screenX = poi.markerX() + xOffset;
            int screenY = poi.markerY() + yOffset;
            PoiButton button = PoiButton.create(this.font, screenX, screenY, poi, () -> this.doWarp(poi.id()));
            this.addRenderableWidget((GuiEventListener)button);
            this.poiButtons.add(button);
        }
    }

    public void tick() {
        super.tick();
        for (PoiButton button : this.poiButtons) {
            button.tick();
        }
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderBackground(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        int h = (this.height - 256) / 2;
        int w = (this.width - 256) / 2;
        graphics.blit(this.map.texture(), w, h, 0, 0.0f, 0.0f, 256, 256, 256, 256);
    }

    private void doWarp(ResourceKey<PoiConfig> id) {
        Player player = this.player;
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            localPlayer.connection.sendUnsignedCommand("warp " + String.valueOf(id.location()));
            this.onClose();
        }
    }
}

