/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.world_effect;

import java.util.Objects;

public class EffectInterpolator<T> {
    private final Function<T> function;
    private T lastState;
    private T state;
    private T targetState;
    private int interpolationSteps;

    public EffectInterpolator(Function<T> function, T defaultState) {
        this.function = function;
        this.targetState = defaultState;
        this.state = this.targetState;
        this.lastState = this.targetState;
    }

    public void step() {
        this.lastState = this.state;
        if (this.interpolationSteps > 0) {
            int steps;
            this.state = (steps = this.interpolationSteps--) != 1 ? this.function.apply(this.state, this.targetState, 1.0f / (float)steps) : this.targetState;
        }
    }

    public void setTarget(T state, int steps) {
        this.targetState = state;
        this.interpolationSteps = steps;
        if (steps == 0) {
            this.lastState = state;
            this.state = this.lastState;
        }
    }

    public void reset(T state) {
        this.setTarget(state, 0);
    }

    public T get(float partialTicks) {
        if (Objects.equals(this.state, this.lastState)) {
            return this.state;
        }
        return this.function.apply(this.lastState, this.state, partialTicks);
    }

    public static interface Function<T> {
        public T apply(T var1, T var2, float var3);
    }
}

