/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.client.world_effect;

import com.lovetropics.extras.world_effect.ParticlesEffect;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
public class WorldParticleEffectHandler {
    @Nullable
    private static ParticlesEffect effect;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            effect = null;
            return;
        }
        if (effect != null && !minecraft.isPaused()) {
            for (ParticlesEffect.Particle particle : effect.particles()) {
                WorldParticleEffectHandler.addParticles(player.level(), player.getRandom(), player.blockPosition(), particle);
            }
        }
    }

    private static void addParticles(Level level, RandomSource random, BlockPos playerPosition, ParticlesEffect.Particle particle) {
        int range = particle.range();
        BlockPos origin = playerPosition.offset(particle.offset());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < particle.count(); ++i) {
            pos.setWithOffset((Vec3i)origin, random.nextInt(range) - random.nextInt(range), random.nextInt(range) - random.nextInt(range), random.nextInt(range) - random.nextInt(range));
            BlockState state = level.getBlockState((BlockPos)pos);
            if (state.isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)pos)) continue;
            level.addParticle(particle.particle(), (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public static void set(@Nullable ParticlesEffect effect) {
        WorldParticleEffectHandler.effect = effect;
    }
}

