/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.collectible.CollectibleMarker;
import com.lovetropics.extras.registry.ExtraRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Collectible
implements DataComponentHolder {
    public static final Codec<Collectible> DIRECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(c -> c.item), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(c -> c.components)).apply((Applicative)i, Collectible::new));
    public static final Codec<Holder<Collectible>> CODEC = RegistryFileCodec.create(ExtraRegistries.COLLECTIBLE, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Collectible> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), c -> c.item, (StreamCodec)DataComponentPatch.STREAM_CODEC, c -> c.components, Collectible::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Collectible>> STREAM_CODEC = ByteBufCodecs.holder(ExtraRegistries.COLLECTIBLE, DIRECT_STREAM_CODEC);
    private final Holder<Item> item;
    private final DataComponentPatch components;
    private final DataComponentMap combinedComponents;

    private Collectible(Holder<Item> item, DataComponentPatch components) {
        this.item = item;
        this.components = components;
        this.combinedComponents = PatchedDataComponentMap.fromPatch((DataComponentMap)((Item)item.value()).components(), (DataComponentPatch)components);
    }

    public Collectible(ItemStack stack) {
        this((Holder<Item>)stack.getItemHolder(), Collectible.componentsWithoutMarker(stack.getComponentsPatch()));
    }

    @Nullable
    public static Holder<Collectible> byItem(ItemStack stack) {
        CollectibleMarker marker = (CollectibleMarker)stack.get(ExtraDataComponents.COLLECTIBLE);
        if (marker == null) {
            return null;
        }
        return marker.collectible().orElseGet(() -> Holder.direct((Object)new Collectible(stack)));
    }

    public static boolean isCollectible(ItemStack stack) {
        return stack.has(ExtraDataComponents.COLLECTIBLE);
    }

    public static boolean isIllegalCollectible(ItemStack stack, Player player) {
        CollectibleMarker marker = (CollectibleMarker)stack.get(ExtraDataComponents.COLLECTIBLE);
        if (marker == null) {
            return false;
        }
        return marker.ownerId().isPresent() && !player.getUUID().equals(marker.ownerId().get());
    }

    public static ItemStack createItemStack(Holder<Collectible> collectible, UUID player) {
        ItemStack stack = new ItemStack(((Collectible)collectible.value()).item());
        stack.applyComponents(((Collectible)collectible.value()).components());
        Collectible.addMarkerTo(player, collectible, stack);
        return stack;
    }

    public static void addMarkerTo(UUID player, Holder<Collectible> collectible, ItemStack stack) {
        stack.set(ExtraDataComponents.COLLECTIBLE, (Object)new CollectibleMarker(collectible.kind() == Holder.Kind.REFERENCE ? Optional.of(collectible) : Optional.empty(), Optional.of(player)));
    }

    public Holder<Item> item() {
        return this.item;
    }

    public DataComponentPatch components() {
        return this.components;
    }

    public static boolean matches(Holder<Collectible> collectible, ItemStack stack) {
        CollectibleMarker marker = (CollectibleMarker)stack.get(ExtraDataComponents.COLLECTIBLE);
        if (marker == null) {
            return false;
        }
        if (marker.collectible().isPresent()) {
            return marker.collectible().get().equals(collectible);
        }
        if (!stack.is(((Collectible)collectible.value()).item())) {
            return false;
        }
        return ((Collectible)collectible.value()).components().equals((Object)Collectible.componentsWithoutMarker(stack.getComponentsPatch()));
    }

    private static DataComponentPatch componentsWithoutMarker(DataComponentPatch components) {
        return components.forget(type -> type == ExtraDataComponents.COLLECTIBLE.value());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Collectible) {
            Collectible collectible = (Collectible)obj;
            return this.item.equals(collectible.item) && this.components.equals((Object)collectible.components);
        }
        return false;
    }

    public int hashCode() {
        return this.item.hashCode() * 31 + this.components.hashCode();
    }

    public DataComponentMap getComponents() {
        return this.combinedComponents;
    }
}

