/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.lovetropics.extras.ExtraTags;
import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleLister;
import com.lovetropics.extras.collectible.CollectibleStore;
import com.lovetropics.extras.entity.CollectibleEntity;
import com.lovetropics.extras.entity.ExtraEntities;
import com.lovetropics.extras.mixin.ResourceKeyArgumentAccessor;
import com.lovetropics.extras.registry.ExtraRegistries;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CollectibleCommand {
    private static final SimpleCommandExceptionType GAVE_TO_NO_PLAYERS = new SimpleCommandExceptionType((Message)Component.literal((String)"Did not find any players to give this collectible to"));
    private static final SimpleCommandExceptionType CLEARED_FROM_NO_PLAYERS = new SimpleCommandExceptionType((Message)Component.literal((String)"Did not find any players to remove this collectible from"));
    private static final DynamicCommandExceptionType ERROR_INVALID_COLLECTIBLE = new DynamicCommandExceptionType(name -> Component.translatableEscape((String)"There is no collectible with id: '%s'", (Object[])new Object[]{name}));
    private static final ResourceKey<Item> DISGUISE = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ltminigames", (String)"disguise"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"collectible").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"give").then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"item").then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)buildContext)).executes(c -> CollectibleCommand.give((CommandContext<CommandSourceStack>)c, (Collection<ServerPlayer>)EntityArgument.getPlayers((CommandContext)c, (String)"target"), ItemArgument.getItem((CommandContext)c, (String)"item")))))).then(Commands.argument((String)"collectible", (ArgumentType)ResourceOrTagArgument.resourceOrTag((CommandBuildContext)buildContext, ExtraRegistries.COLLECTIBLE)).executes(c -> CollectibleCommand.give((CommandContext<CommandSourceStack>)c, (Collection<ServerPlayer>)EntityArgument.getPlayers((CommandContext)c, (String)"target"), (ResourceOrTagArgument.Result<Collectible>)ResourceOrTagArgument.getResourceOrTag((CommandContext)c, (String)"collectible", ExtraRegistries.COLLECTIBLE))))))).then(Commands.literal((String)"clear").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"item").then(Commands.argument((String)"item", (ArgumentType)ItemPredicateArgument.itemPredicate((CommandBuildContext)buildContext)).executes(c -> CollectibleCommand.clear((CommandContext<CommandSourceStack>)c, EntityArgument.getPlayers((CommandContext)c, (String)"target"), CollectibleCommand.itemToCollectiblePredicate((Predicate<ItemStack>)ItemPredicateArgument.getItemPredicate((CommandContext)c, (String)"item"))))))).then(Commands.argument((String)"collectible", (ArgumentType)ResourceOrTagArgument.resourceOrTag((CommandBuildContext)buildContext, ExtraRegistries.COLLECTIBLE)).executes(c -> CollectibleCommand.clear((CommandContext<CommandSourceStack>)c, EntityArgument.getPlayers((CommandContext)c, (String)"target"), (Predicate<Holder<Collectible>>)ResourceOrTagArgument.getResourceOrTag((CommandContext)c, (String)"collectible", ExtraRegistries.COLLECTIBLE))))).executes(c -> CollectibleCommand.clear((CommandContext<CommandSourceStack>)c, EntityArgument.getPlayers((CommandContext)c, (String)"target"), i -> true))))).then(Commands.literal((String)"lock").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(context -> CollectibleCommand.setLocked((CommandContext<CommandSourceStack>)context, true))))).then(Commands.literal((String)"unlock").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(context -> CollectibleCommand.setLocked((CommandContext<CommandSourceStack>)context, false))))).then(Commands.literal((String)"summon").then(Commands.argument((String)"collectible", (ArgumentType)ResourceKeyArgument.key(ExtraRegistries.COLLECTIBLE)).executes(c -> CollectibleCommand.summonCollectible((CommandContext<CommandSourceStack>)c, CollectibleCommand.getCollectible((CommandContext<CommandSourceStack>)c, "collectible")))))).then(Commands.literal((String)"countdisguises").executes(CollectibleCommand::countDisguises))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"find").executes(context -> CollectibleCommand.findCollectibles((CommandSourceStack)context.getSource(), stack -> true))).then(Commands.argument((String)"collectible", (ArgumentType)ResourceOrTagArgument.resourceOrTag((CommandBuildContext)buildContext, ExtraRegistries.COLLECTIBLE)).executes(context -> CollectibleCommand.findCollectibles((CommandSourceStack)context.getSource(), (Predicate<Holder<Collectible>>)ResourceOrTagArgument.getResourceOrTag((CommandContext)context, (String)"collectible", ExtraRegistries.COLLECTIBLE))))).then(Commands.literal((String)"item").then(Commands.argument((String)"item", (ArgumentType)ItemPredicateArgument.itemPredicate((CommandBuildContext)buildContext)).executes(context -> CollectibleCommand.findCollectibles((CommandSourceStack)context.getSource(), CollectibleCommand.itemToCollectiblePredicate((Predicate<ItemStack>)ItemPredicateArgument.getItemPredicate((CommandContext)context, (String)"item"))))))));
    }

    private static Holder.Reference<Collectible> getCollectible(CommandContext<CommandSourceStack> context, String argument) throws CommandSyntaxException {
        return ResourceKeyArgumentAccessor.callResolveKey(context, argument, ExtraRegistries.COLLECTIBLE, ERROR_INVALID_COLLECTIBLE);
    }

    private static int give(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, ItemInput item) throws CommandSyntaxException {
        ItemStack stack = item.createItemStack(1, true);
        return CollectibleCommand.giveSingle(ctx, players, (Holder<Collectible>)Holder.direct((Object)new Collectible(stack)));
    }

    private static int give(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, ResourceOrTagArgument.Result<Collectible> collectibles) throws CommandSyntaxException {
        Either either = collectibles.unwrap();
        if (either.left().isPresent()) {
            return CollectibleCommand.giveSingle(ctx, players, (Holder<Collectible>)((Holder)either.left().get()));
        }
        return CollectibleCommand.giveTag(ctx, players, (HolderSet.Named<Collectible>)((HolderSet.Named)either.right().orElseThrow()));
    }

    private static int giveSingle(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, Holder<Collectible> collectible) throws CommandSyntaxException {
        int result = 0;
        for (ServerPlayer player : players) {
            CollectibleStore collectibles = CollectibleStore.get((Player)player);
            if (!collectibles.give(collectible)) continue;
            ++result;
        }
        if (result == 0) {
            throw GAVE_TO_NO_PLAYERS.create();
        }
        int finalResult = result;
        ItemStack stack = Collectible.createItemStack(collectible, Util.NIL_UUID);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"Gave %s to %s players", (Object[])new Object[]{stack.getDisplayName(), finalResult}), false);
        return result;
    }

    private static int giveTag(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, HolderSet.Named<Collectible> collectiblesToGive) throws CommandSyntaxException {
        int result = 0;
        for (ServerPlayer player : players) {
            CollectibleStore collectibles = CollectibleStore.get((Player)player);
            for (Holder collectible : collectiblesToGive) {
                if (!collectibles.give((Holder<Collectible>)collectible)) continue;
                ++result;
            }
        }
        if (result == 0) {
            throw GAVE_TO_NO_PLAYERS.create();
        }
        int finalResult = result;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"Gave %s to %s players", (Object[])new Object[]{Component.translationArg((ResourceLocation)collectiblesToGive.key().location()), finalResult}), false);
        return result;
    }

    private static int summonCollectible(CommandContext<CommandSourceStack> ctx, Holder<Collectible> collectible) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        CollectibleEntity entity = new CollectibleEntity((EntityType)ExtraEntities.COLLECTIBLE.get(), (Level)level);
        entity.moveTo(((CommandSourceStack)ctx.getSource()).getPosition());
        entity.setCollectible(collectible);
        level.addFreshEntity((Entity)entity);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"Summoned '%s' Collectible", (Object[])new Object[]{entity.getDisplayName()}), false);
        return 1;
    }

    private static Predicate<Holder<Collectible>> itemToCollectiblePredicate(Predicate<ItemStack> itemPredicate) {
        return collectible -> itemPredicate.test(Collectible.createItemStack((Holder<Collectible>)collectible, Util.NIL_UUID));
    }

    private static int clear(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, Predicate<Holder<Collectible>> predicate) throws CommandSyntaxException {
        int count = 0;
        for (ServerPlayer player : players) {
            CollectibleStore collectibles = CollectibleStore.get((Player)player);
            if (!collectibles.clear(predicate)) continue;
            CollectibleCommand.clearCollectibleItems(player.getInventory(), predicate);
            ++count;
        }
        if (count == 0) {
            throw CLEARED_FROM_NO_PLAYERS.create();
        }
        int finalCount = count;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"Cleared collectibles from %s players", (Object[])new Object[]{finalCount}), false);
        return finalCount;
    }

    private static void clearCollectibleItems(Inventory inventory, Predicate<Holder<Collectible>> predicate) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            Holder<Collectible> collectible = Collectible.byItem(stack);
            if (collectible == null || !predicate.test(collectible)) continue;
            inventory.removeItemNoUpdate(i);
        }
    }

    private static int countDisguises(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        CollectibleStore collectibles = CollectibleStore.get((Player)player);
        return collectibles.count(collectible -> ((Collectible)collectible.value()).item().is(DISGUISE) && !collectible.is(ExtraTags.Collectibles.DONATION_GOAL));
    }

    private static int setLocked(CommandContext<CommandSourceStack> context, boolean locked) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        CollectibleStore store = CollectibleStore.get((Player)player);
        store.setLocked(locked);
        return 1;
    }

    private static int findCollectibles(CommandSourceStack source, Predicate<Holder<Collectible>> predicate) {
        MinecraftServer server = source.getServer();
        GameProfileCache profileCache = server.getProfileCache();
        ((CompletableFuture)CollectibleLister.listPlayersWithItem(server, predicate).thenApplyAsync(profileIds -> profileIds.stream().map(arg_0 -> ((GameProfileCache)profileCache).get(arg_0)).flatMap(Optional::stream).toList(), (Executor)Util.backgroundExecutor())).thenAcceptAsync(profiles -> {
            if (profiles.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)"Found no players"), false);
            } else {
                String names = profiles.stream().map(GameProfile::getName).collect(Collectors.joining(", "));
                source.sendSuccess(() -> Component.literal((String)("Found " + profiles.size() + " players: " + names)), false);
            }
        }, (Executor)server);
        return 1;
    }
}

