/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleStore;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerDestroyItemEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="ltextras")
public class CollectibleItemBehavior {
    private static final int INVENTORY_CHECK_INTERVAL = 20;

    public static boolean onItemToss(Player player, ItemEntity item) {
        ItemStack stack = item.getItem();
        if (Collectible.isCollectible(stack)) {
            player.addItem(stack);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onItemPickup(ItemEntityPickupEvent.Pre event) {
        ItemStack stack = event.getItemEntity().getItem();
        Holder<Collectible> collectible = Collectible.byItem(stack);
        if (collectible == null) {
            return;
        }
        Player player = event.getPlayer();
        if (Collectible.isIllegalCollectible(stack, player)) {
            stack.setCount(0);
            event.getItemEntity().discard();
            event.setCanPickup(TriState.FALSE);
        } else {
            CollectibleStore store = CollectibleStore.get(player);
            store.give(collectible);
            Collectible.addMarkerTo(player.getUUID(), collectible, stack);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        event.getDrops().removeIf(item -> Collectible.isCollectible(item.getItem()));
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            Inventory inventory;
            int count;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.tickCount % 20 == 0 && (count = (inventory = serverPlayer.getInventory()).clearOrCountMatchingItems(stack -> Collectible.isIllegalCollectible(stack, (Player)serverPlayer), -1, (Container)serverPlayer.inventoryMenu.getCraftSlots())) > 0) {
                serverPlayer.containerMenu.broadcastChanges();
                serverPlayer.inventoryMenu.slotsChanged((Container)inventory);
            }
        }
    }

    @SubscribeEvent
    public static void onDestroyItem(PlayerDestroyItemEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack item = event.getOriginal();
            if (Collectible.isCollectible(item)) {
                player2.addItem(item);
            }
        }
    }

    @SubscribeEvent
    public static void onFinishUsingItem(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        if (Collectible.isCollectible(stack) && event.getResultStack().isEmpty()) {
            event.setResultStack(stack);
        }
    }

    public static InteractionResultHolder<ItemStack> wrapUse(ItemStack stack, Level level, Player player, InteractionHand hand) {
        if (Collectible.isCollectible(stack)) {
            int count = stack.getCount();
            ItemStack oldStack = stack.copy();
            InteractionResultHolder result = stack.getItem().use(level, player, hand);
            if (!CollectibleItemBehavior.isEquipped(player, oldStack)) {
                stack.setCount(count);
            }
            return result;
        }
        return stack.getItem().use(level, player, hand);
    }

    public static InteractionResult wrapUseOn(ItemStack stack, UseOnContext context) {
        if (Collectible.isCollectible(stack)) {
            int count = stack.getCount();
            InteractionResult result = stack.useOn(context);
            stack.setCount(count);
            return result;
        }
        return stack.useOn(context);
    }

    private static boolean isEquipped(Player player, ItemStack stack) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)player.getItemBySlot(slot), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }
}

