/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.collectible;

import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleData;
import com.lovetropics.extras.data.attachment.ExtraAttachments;
import com.lovetropics.extras.network.message.ClientboundCollectiblesListPacket;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="ltextras")
public class CollectibleStore {
    public static final Codec<CollectibleStore> CODEC = CollectibleData.CODEC.xmap(data -> {
        CollectibleStore store = new CollectibleStore();
        store.collectibles.clear();
        store.collectibles.addAll(data.collectibles());
        store.hasUnseen = data.hasUnseen();
        return store;
    }, CollectibleStore::asData);
    @Nullable
    private ServerPlayer player;
    private final List<Holder<Collectible>> collectibles = new ArrayList<Holder<Collectible>>();
    private boolean hasUnseen;
    private boolean locked;

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CollectibleStore collectibles = CollectibleStore.get(event.getEntity());
        collectibles.sendToClient(true);
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        if (event.isWasDeath()) {
            CollectibleStore oldCollectibles = CollectibleStore.get(oldPlayer);
            CollectibleStore newCollectibles = CollectibleStore.get(event.getEntity());
            newCollectibles.collectibles.addAll(oldCollectibles.collectibles);
            newCollectibles.sendToClient(true);
        }
    }

    public static CollectibleStore get(Player player) {
        CollectibleStore data = (CollectibleStore)player.getData(ExtraAttachments.COLLECTIBLE_STORE);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer;
            data.player = serverPlayer = (ServerPlayer)player;
        }
        return data;
    }

    public CollectibleData asData() {
        return new CollectibleData(this.collectibles, this.hasUnseen);
    }

    public boolean give(Holder<Collectible> collectible) {
        if (!this.collectibles.contains(collectible)) {
            this.collectibles.add(collectible);
            this.hasUnseen = true;
            this.sendToClient(false);
            return true;
        }
        return false;
    }

    public boolean clear(Predicate<Holder<Collectible>> predicate) {
        if (this.collectibles.removeIf(predicate)) {
            this.sendToClient(false);
            return true;
        }
        return false;
    }

    public boolean contains(Holder<Collectible> collectible) {
        return this.collectibles.contains(collectible);
    }

    public int count(Predicate<Holder<Collectible>> predicate) {
        int count = 0;
        for (Holder<Collectible> collectible : this.collectibles) {
            if (!predicate.test(collectible)) continue;
            ++count;
        }
        return count;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void markSeen() {
        this.hasUnseen = false;
    }

    private void sendToClient(boolean silent) {
        if (this.player != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)this.player, (CustomPacketPayload)new ClientboundCollectiblesListPacket(this.collectibles, silent, this.hasUnseen), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

