/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagFile;

public class GenerateCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final DynamicCommandExceptionType FAILED_TO_WRITE = new DynamicCommandExceptionType(o -> Component.literal((String)("Failed to write to file: " + String.valueOf(o))));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"generate").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"tag").then(Commands.literal((String)"item").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"pattern", (ArgumentType)StringArgumentType.greedyString()).executes(GenerateCommand::generateItemTag))))));
    }

    private static int generateItemTag(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Pattern pattern = Pattern.compile(StringArgumentType.getString(ctx, (String)"pattern"));
        TagBuilder tagBuilder = TagBuilder.create();
        for (Map.Entry e : BuiltInRegistries.ITEM.entrySet()) {
            ResourceLocation id = ((ResourceKey)e.getKey()).location();
            if (!pattern.matcher(id.toString()).matches()) continue;
            tagBuilder.addElement(id);
        }
        JsonElement json = (JsonElement)TagFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(tagBuilder.build(), false, List.of())).getOrThrow();
        Path output = Paths.get("export", "generated", "tags", "item", StringArgumentType.getString(ctx, (String)"name") + ".json");
        try {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.write(output, Collections.singleton(GSON.toJson(json)), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw FAILED_TO_WRITE.create((Object)e1);
        }
        return 1;
    }
}

