/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.command;

import com.lovetropics.extras.data.poi.MapManager;
import com.lovetropics.extras.data.poi.PoiConfig;
import com.lovetropics.extras.registry.ExtraRegistries;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;

public class PoiCommand {
    private static final String COMMAND_BASE = "poi";
    private static final SimpleCommandExceptionType GENERAL_ERROR = new SimpleCommandExceptionType((Message)Component.literal((String)"General error"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)COMMAND_BASE).requires(source -> source.hasPermission(2))).then(Commands.literal((String)"enable").then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> SharedSuggestionProvider.suggestResource(PoiCommand.suggestDisabledPois((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder)).executes(PoiCommand::enable))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)COMMAND_BASE).requires(source -> source.hasPermission(2))).then(Commands.literal((String)"disable").then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> SharedSuggestionProvider.suggestResource(PoiCommand.suggestEnabledPois((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)builder)).executes(PoiCommand::disable))));
    }

    private static int enable(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocationArgument.getId(ctx, (String)"id");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        if (!MapManager.get(server).enable(server, (ResourceKey<PoiConfig>)ResourceKey.create(ExtraRegistries.POI, (ResourceLocation)id))) {
            throw GENERAL_ERROR.create();
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Enabled POI \"" + String.valueOf(id) + "\"")), false);
        return 1;
    }

    private static int disable(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocationArgument.getId(ctx, (String)"id");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        if (!MapManager.get(server).disable(server, (ResourceKey<PoiConfig>)ResourceKey.create(ExtraRegistries.POI, (ResourceLocation)id))) {
            throw GENERAL_ERROR.create();
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Disabled POI \"" + String.valueOf(id) + "\"")), false);
        return 1;
    }

    private static Stream<ResourceLocation> suggestEnabledPois(CommandContext<CommandSourceStack> ctx) {
        return MapManager.get(((CommandSourceStack)ctx.getSource()).getServer()).getEnabledPois().map(ResourceKey::location);
    }

    private static Stream<ResourceLocation> suggestDisabledPois(CommandContext<CommandSourceStack> ctx) {
        return MapManager.get(((CommandSourceStack)ctx.getSource()).getServer()).getDisabledPois().map(ResourceKey::location);
    }
}

