/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.command;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.lovetropics.extras.ExtrasConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class TpCommand {
    private static final String ARGUMENT_NAME = "name";
    private static final SimpleCommandExceptionType PLAYER_NOT_FOUND = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.tpa.player_not_found"));
    private static final SimpleCommandExceptionType REQUEST_NOT_FOUND = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.tpa.request_not_found"));
    private static final SimpleCommandExceptionType GENERAL_ERROR = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.tpa.general_error"));
    private static final SimpleCommandExceptionType TOO_MUCH = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.tpa.too_much"));
    private static final SimpleCommandExceptionType ALREADY_PENDING = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.tpa.pending_request_exists"));
    private static final SimpleCommandExceptionType NO_SELF_TELEPORT = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.tpa.no_self_teleport"));
    private static final SimpleCommandExceptionType NOT_ALLOWED_HERE = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.tpa.not_allowed_here"));
    private static final int REQUEST_CACHE_SIZE = 50;
    private static final Duration REQUEST_TIMEOUT_DURATION = Duration.ofMinutes(1L);
    private static final Cache<UUID, UUID> requestCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(REQUEST_TIMEOUT_DURATION).build();
    private static final Cache<UUID, GlobalPos> backCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(REQUEST_TIMEOUT_DURATION).build();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"tpa").then(Commands.argument((String)ARGUMENT_NAME, (ArgumentType)EntityArgument.player()).executes(TpCommand::tpRequest)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpaccept").then(Commands.argument((String)ARGUMENT_NAME, (ArgumentType)EntityArgument.player()).executes(TpCommand::tpAccept))).then(Commands.literal((String)"all").executes(TpCommand::acceptAllTpRequests)));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"back").executes(TpCommand::tpBack));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"tphelp").executes(TpCommand::tpHelp));
    }

    private static int tpHelp(CommandContext<CommandSourceStack> ctx) {
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.tpa.help.tpa"), false);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.tpa.help.tpaccept"), false);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.tpa.help.back"), false);
        return 1;
    }

    private static int tpBack(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        GlobalPos globalPos = (GlobalPos)backCache.getIfPresent((Object)((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID());
        if (globalPos == null) {
            throw GENERAL_ERROR.create();
        }
        ServerPlayer executingPlayer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        GlobalPos newBackPos = GlobalPos.of((ResourceKey)executingPlayer.level().dimension(), (BlockPos)executingPlayer.blockPosition());
        TpCommand.doTeleport(executingPlayer, globalPos);
        backCache.put((Object)executingPlayer.getUUID(), (Object)newBackPos);
        return 1;
    }

    private static int tpAccept(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer tpRequester = EntityArgument.getPlayer(ctx, (String)ARGUMENT_NAME);
        UUID requestedTarget = (UUID)requestCache.getIfPresent((Object)tpRequester.getUUID());
        UUID commandExecutor = ((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID();
        if (requestedTarget == null || !requestedTarget.equals(commandExecutor)) {
            throw REQUEST_NOT_FOUND.create();
        }
        ServerPlayer executingPlayer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        TpCommand.teleportAndSendMessage(tpRequester, executingPlayer);
        return 1;
    }

    private static int acceptAllTpRequests(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer executingPlayer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        Map<UUID, UUID> requesterTargetMap = requestCache.asMap().entrySet().stream().filter(entry -> ((UUID)entry.getValue()).equals(executingPlayer.getUUID())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<UUID, UUID> e : requesterTargetMap.entrySet()) {
            ServerPlayer playerToTeleport = TpCommand.nonNullPlayerByUUID(ctx, e.getKey());
            TpCommand.teleportAndSendMessage(playerToTeleport, executingPlayer);
        }
        return 1;
    }

    private static int tpRequest(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer requestingPlayer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ServerPlayer targetPlayer = EntityArgument.getPlayer(ctx, (String)ARGUMENT_NAME);
        if (requestingPlayer.getUUID().equals(targetPlayer.getUUID())) {
            throw NO_SELF_TELEPORT.create();
        }
        TpCommand.spamCheck(requestingPlayer.getUUID());
        Style style = Style.EMPTY.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept " + requestingPlayer.getGameProfile().getName()));
        MutableComponent hereComponent = Component.translatable((String)"commands.tpa.here").withStyle(style);
        MutableComponent translatable = Component.translatable((String)"commands.tpa.request", (Object[])new Object[]{requestingPlayer.getName(), hereComponent, requestingPlayer.getName()});
        targetPlayer.sendSystemMessage((Component)translatable);
        requestingPlayer.sendSystemMessage((Component)Component.translatable((String)"commands.tpa.request_sent"));
        requestCache.put((Object)requestingPlayer.getUUID(), (Object)targetPlayer.getUUID());
        return 1;
    }

    private static void teleportAndSendMessage(ServerPlayer player, ServerPlayer target) throws CommandSyntaxException {
        requestCache.invalidate((Object)player.getUUID());
        GlobalPos globalPos = GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)player.blockPosition());
        backCache.put((Object)player.getUUID(), (Object)globalPos);
        TpCommand.doTeleport(player, GlobalPos.of((ResourceKey)target.level().dimension(), (BlockPos)target.blockPosition()));
        player.sendSystemMessage((Component)Component.translatable((String)"commands.tpa.tp_accepted", (Object[])new Object[]{target.getName().getString()}));
    }

    private static void doTeleport(ServerPlayer player, GlobalPos globalPos) throws CommandSyntaxException {
        Predicate<ResourceKey<Level>> dimensionPredicate = TpCommand.dimensionPredicate();
        if (!dimensionPredicate.test((ResourceKey<Level>)player.serverLevel().dimension()) || !dimensionPredicate.test((ResourceKey<Level>)globalPos.dimension())) {
            throw NOT_ALLOWED_HERE.create();
        }
        ServerLevel level = player.getServer().getLevel(globalPos.dimension());
        player.teleportTo(level, (double)globalPos.pos().getX(), (double)globalPos.pos().getY(), (double)globalPos.pos().getZ(), player.getYRot(), player.getXRot());
    }

    private static Predicate<ResourceKey<Level>> dimensionPredicate() {
        String string = (String)ExtrasConfig.COMMANDS.tpaDimension.get();
        ResourceLocation id = ResourceLocation.tryParse((String)string);
        if (string.isBlank() || id == null) {
            return level -> true;
        }
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
        return dimension -> dimension == key;
    }

    private static void spamCheck(UUID requester) throws CommandSyntaxException {
        if (requestCache.getIfPresent((Object)requester) != null) {
            throw ALREADY_PENDING.create();
        }
    }

    private static ServerPlayer nonNullPlayerByUUID(CommandContext<CommandSourceStack> ctx, UUID uuid) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayer(uuid);
        if (player == null) {
            throw PLAYER_NOT_FOUND.create();
        }
        return player;
    }

    public static void addTranslations(RegistrateLangProvider provider) {
        provider.add("commands.tpa.request", "%s wants to teleport to you. Click %s (/tpaccept %s) to accept");
        provider.add("commands.tpa.here", "[here]");
        provider.add("commands.tpa.tp_accepted", "%s has accepted your teleport request. Use /back to return");
        provider.add("commands.tpa.too_much", "You are doing that too much");
        provider.add("commands.tpa.request_sent", "Request sent");
        provider.add("commands.tpa.player_not_found", "Player not found");
        provider.add("commands.tpa.request_not_found", "No teleport request");
        provider.add("commands.tpa.general_error", "Unable to teleport");
        provider.add("commands.tpa.help.tpa", "/tpa <player> - Request to teleport to a player");
        provider.add("commands.tpa.help.tpaccept", "/tpaccept <player> - Accept a teleport request from a player. Use \"all\" to accept all pending requests");
        provider.add("commands.tpa.help.back", "/back - Teleport back to where you were before teleporting");
        provider.add("commands.tpa.pending_request_exists", "A request is still pending");
        provider.add("commands.tpa.no_self_teleport", "You can't teleport to yourself");
        provider.add("commands.tpa.not_allowed_here", "Teleporting is not allowed here");
    }
}

