/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data;

import com.lovetropics.extras.BlockFactory;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public final class ImposterBlockTemplate {
    public final BlockFactory<? extends Block> factory;
    public final Model model;

    public ImposterBlockTemplate(BlockFactory<? extends Block> factory, Model model) {
        this.factory = factory;
        this.model = model;
    }

    public static ImposterBlockTemplate simpleCube() {
        return ImposterBlockTemplate.cube(Block::new);
    }

    public static ImposterBlockTemplate halfTransparentCube() {
        return new ImposterBlockTemplate(HalfTransparentBlock::new, Model.HALF_TRANSPARENT_CUBE);
    }

    public static ImposterBlockTemplate cube(BlockFactory<? extends Block> factory) {
        return new ImposterBlockTemplate(factory, Model.CUBE);
    }

    public static ImposterBlockTemplate cross(BlockFactory<? extends Block> factory) {
        return new ImposterBlockTemplate(factory, Model.CROSS);
    }

    public static enum Model {
        CUBE,
        HALF_TRANSPARENT_CUBE,
        CROSS;


        public BlockBuilder<? extends Block, Registrate> apply(BlockBuilder<? extends Block, Registrate> block, ResourceLocation id) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> block.blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().getExistingFile(id))).simpleItem();
                case 1 -> block.blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().getExistingFile(id))).addLayer(() -> RenderType::translucent).simpleItem();
                case 2 -> {
                    ResourceLocation texture = id.withPath("block/" + id.getPath());
                    yield ((BlockBuilder)block.blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cross(ctx.getName(), texture))).item().model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{texture})).build()).addLayer(() -> RenderType::cutout);
                }
            };
        }
    }
}

