/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.poi;

import com.lovetropics.extras.data.poi.MapConfig;
import com.lovetropics.lib.codec.MoreCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record PoiConfig(Holder<MapConfig> map, Component description, Icon icon, BlockPos pos, Optional<Float> angle) {
    public static final Codec<PoiConfig> CODEC = RecordCodecBuilder.create(i -> i.group((App)MapConfig.CODEC.fieldOf("map").forGetter(PoiConfig::map), (App)ComponentSerialization.CODEC.fieldOf("description").forGetter(PoiConfig::description), (App)Icon.CODEC.fieldOf("icon").forGetter(PoiConfig::icon), (App)BlockPos.CODEC.fieldOf("pos").forGetter(PoiConfig::pos), (App)Codec.FLOAT.optionalFieldOf("angle").forGetter(PoiConfig::angle)).apply((Applicative)i, PoiConfig::new));

    public static sealed interface Icon
    permits TextureIcon, ItemIcon {
        public static final Codec<Icon> CODEC = Codec.either(TextureIcon.CODEC, ItemIcon.CODEC).xmap(either -> (Icon)either.map(Function.identity(), Function.identity()), Icon::toEither);
        public static final StreamCodec<RegistryFriendlyByteBuf, Icon> STREAM_CODEC = ByteBufCodecs.either(TextureIcon.STREAM_CODEC, ItemIcon.STREAM_CODEC).map(either -> (Icon)either.map(Function.identity(), Function.identity()), Icon::toEither);

        private static Either<TextureIcon, ItemIcon> toEither(Icon icon) {
            Icon icon2 = icon;
            Objects.requireNonNull(icon2);
            Icon icon3 = icon2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextureIcon.class, ItemIcon.class}, (Object)icon3, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    TextureIcon texture = (TextureIcon)icon3;
                    yield Either.left((Object)texture);
                }
                case 1 -> {
                    ItemIcon item = (ItemIcon)icon3;
                    yield Either.right((Object)item);
                }
            };
        }
    }

    public record ItemIcon(ItemStack item) implements Icon
    {
        public static final Codec<ItemIcon> CODEC = RecordCodecBuilder.create(i -> i.group((App)MoreCodecs.ITEM_STACK.fieldOf("item").forGetter(ItemIcon::item)).apply((Applicative)i, ItemIcon::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemIcon> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ItemIcon::item, ItemIcon::new);
    }

    public record TextureIcon(ResourceLocation texture) implements Icon
    {
        public static final Codec<TextureIcon> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(TextureIcon::texture)).apply((Applicative)i, TextureIcon::new));
        public static final StreamCodec<ByteBuf, TextureIcon> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, TextureIcon::texture, TextureIcon::new);
    }
}

