/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.spawnitems;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record SpawnItems(List<Stack> items, boolean canBeRestored, Optional<String> excludeTag) {
    public static final Codec<SpawnItems> CODEC = RecordCodecBuilder.create(in -> in.group((App)Stack.CODEC.listOf().fieldOf("items").forGetter(SpawnItems::items), (App)Codec.BOOL.optionalFieldOf("can_be_restored", (Object)true).forGetter(SpawnItems::canBeRestored), (App)Codec.STRING.optionalFieldOf("exclude_tag").forGetter(SpawnItems::excludeTag)).apply((Applicative)in, SpawnItems::new));

    public boolean canApplyToPlayer(ServerPlayer player) {
        return this.excludeTag.map(tag -> !player.getTags().contains(tag)).orElse(true);
    }

    public record Stack(Holder<Item> item, int count, DataComponentPatch components) {
        private static final Codec<Stack> FULL_CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("id").forGetter(Stack::item), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(Stack::count), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(Stack::components)).apply((Applicative)i, Stack::new));
        public static final Codec<Stack> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)BuiltInRegistries.ITEM.holderByNameCodec(), item -> new Stack((Holder<Item>)item, 1, DataComponentPatch.EMPTY));

        public ItemStack build() {
            return new ItemStack(this.item, this.count, this.components);
        }
    }
}

