/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.spawnitems;

import com.lovetropics.extras.data.spawnitems.SpawnItems;
import com.lovetropics.extras.data.spawnitems.SpawnItemsReloadListener;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class SpawnItemsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"spawnitems").then(Commands.literal((String)"restore").then(Commands.argument((String)"set", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.suggest(SpawnItemsReloadListener.REGISTRY.entrySet().stream().filter(e -> ((SpawnItems)e.getValue()).canBeRestored()).map(e -> ((ResourceLocation)e.getKey()).toString()), (SuggestionsBuilder)builder)).executes(context -> {
            String arg = (String)context.getArgument("set", String.class);
            SpawnItems set = (SpawnItems)SpawnItemsReloadListener.REGISTRY.get((Object)ResourceLocation.parse((String)arg));
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            if (set == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"spawnitems.unknown_set", (Object[])new Object[]{Component.literal((String)arg).withStyle(ChatFormatting.GOLD)}));
                return 1;
            }
            if (!set.canBeRestored() || !set.canApplyToPlayer(player)) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"spawnitems.set_not_restorable", (Object[])new Object[]{Component.literal((String)arg).withStyle(ChatFormatting.GOLD)}));
                return 1;
            }
            for (SpawnItems.Stack stack : set.items()) {
                if (player.addItem(stack.build())) continue;
                player.drop(stack.build(), true, true);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"spawnitems.restored_successfully"), false);
            return 1;
        }))));
    }
}

