/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data.spawnitems;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.lovetropics.extras.data.spawnitems.SpawnItems;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

@EventBusSubscriber(modid="ltextras")
public class SpawnItemsReloadListener
extends SimpleJsonResourceReloadListener {
    public static final BiMap<ResourceLocation, SpawnItems> REGISTRY = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private final HolderLookup.Provider registries;

    public SpawnItemsReloadListener(Gson gson, String directory, HolderLookup.Provider registries) {
        super(gson, directory);
        this.registries = registries;
    }

    @SubscribeEvent
    static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SpawnItemsReloadListener(new GsonBuilder().setLenient().create(), "spawn_items", (HolderLookup.Provider)event.getRegistryAccess()));
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resources, ProfilerFiller profiler) {
        RegistryOps ops = this.registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        profiler.push("lt:spawn_items");
        REGISTRY.clear();
        jsons.forEach((id, json) -> REGISTRY.put(id, (Object)((SpawnItems)SpawnItems.CODEC.parse((DynamicOps)ops, json).getOrThrow(JsonParseException::new))));
        profiler.pop();
    }
}

