/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity;

import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleStore;
import com.lovetropics.extras.item.CollectibleCompassItem;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class CollectibleEntity
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String KEY_COLLECTIBLE = "collectible";
    private static final String KEY_PARTICLES = "particles";
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(CollectibleEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> DATA_PARTICLES = SynchedEntityData.defineId(CollectibleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private Holder<Collectible> collectible;

    public CollectibleEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public ItemStack getDisplayedItem() {
        return (ItemStack)this.getEntityData().get(DATA_ITEM);
    }

    public void setCollectible(@Nullable Holder<Collectible> collectible) {
        this.collectible = collectible;
        this.getEntityData().set(DATA_ITEM, (Object)(collectible != null ? Collectible.createItemStack(collectible, Util.NIL_UUID) : ItemStack.EMPTY));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM, (Object)ItemStack.EMPTY);
        builder.define(DATA_PARTICLES, (Object)true);
    }

    public void playerTouch(Player player) {
        if (!this.level().isClientSide && this.collectible != null) {
            this.tryGiveCollectible(player, this.collectible);
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.collectible == null) {
            return super.interact(player, hand);
        }
        if (!this.level().isClientSide) {
            this.tryGiveCollectible(player, this.collectible);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean skipAttackInteraction(Entity entity) {
        if (this.collectible != null && entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.level().isClientSide) {
                this.tryGiveCollectible(player, this.collectible);
            }
            return true;
        }
        return false;
    }

    private void tryGiveCollectible(Player player, Holder<Collectible> collectible) {
        CollectibleStore collectibles = CollectibleStore.get(player);
        if (collectibles.give(collectible)) {
            this.recycleCollectibleCompass(player);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && this.shouldShowParticles()) {
            this.tickParticles();
        }
    }

    private void tickParticles() {
        double x = this.getX() + this.random.nextGaussian() * 0.2;
        double y = this.getY() + this.random.nextGaussian() * 0.1 + 0.1;
        double z = this.getZ() + this.random.nextGaussian() * 0.2;
        double speedX = this.random.nextGaussian() * 0.005;
        double speedY = this.random.nextGaussian() * 0.005;
        double speedZ = this.random.nextGaussian() * 0.005;
        this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, false, x, y, z, speedX, speedY, speedZ);
    }

    private void setShowParticles(boolean particles) {
        this.getEntityData().set(DATA_PARTICLES, (Object)particles);
    }

    private boolean shouldShowParticles() {
        return (Boolean)this.getEntityData().get(DATA_PARTICLES);
    }

    private void recycleCollectibleCompass(Player player) {
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            CollectibleCompassItem.Target target = (CollectibleCompassItem.Target)stack.get(ExtraDataComponents.COLLECTIBLE_TARGET);
            if (target == null || !target.id().equals(this.getUUID())) continue;
            inventory.removeItemNoUpdate(i);
            int coinCount = (Integer)stack.getOrDefault(ExtraDataComponents.COIN_COUNT, (Object)0);
            if (coinCount <= 0) continue;
            inventory.placeItemBackInInventory(new ItemStack((ItemLike)ExtraItems.TROPICOIN.asItem(), coinCount));
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains(KEY_COLLECTIBLE)) {
            Collectible.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get(KEY_COLLECTIBLE)).resultOrPartial(Util.prefix((String)"Collectible: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(this::setCollectible);
        } else {
            this.setCollectible(null);
        }
        if (tag.contains(KEY_PARTICLES, 1)) {
            this.setShowParticles(tag.getBoolean(KEY_PARTICLES));
        } else {
            this.setShowParticles(true);
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (this.collectible != null) {
            tag.put(KEY_COLLECTIBLE, (Tag)Collectible.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.collectible).getOrThrow());
        }
        tag.putBoolean(KEY_PARTICLES, this.shouldShowParticles());
    }

    public Component getDisplayName() {
        ItemStack displayedItem = this.getDisplayedItem();
        if (!this.hasCustomName()) {
            return displayedItem.getHoverName();
        }
        return super.getDisplayName();
    }

    public boolean shouldShowName() {
        return this.getDisplayName() != null || super.shouldShowName();
    }

    public boolean isPickable() {
        return true;
    }

    @Nullable
    public Holder<Collectible> getCollectible() {
        return this.collectible;
    }
}

