/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity.vfx;

import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class PartyBeamEntity
extends EndCrystal {
    private static final EntityDataAccessor<Vector3f> DATA_COLOR = SynchedEntityData.defineId(PartyBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    @Nullable
    private BlockPos targetPos = null;

    public PartyBeamEntity(EntityType<? extends EndCrystal> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.targetPos != null && this.level().getGameTime() % 100L == 0L) {
            this.random.setSeed(this.level().getGameTime());
            int ax = this.targetPos.getX() + (this.random.nextInt(5) - this.random.nextInt(5));
            int az = this.targetPos.getZ() + (this.random.nextInt(5) - this.random.nextInt(5));
            int packed = Mth.hsvToRgb((float)this.random.nextFloat(), (float)0.8f, (float)0.8f);
            int r = FastColor.ARGB32.red((int)packed);
            int g = FastColor.ARGB32.green((int)packed);
            int b = FastColor.ARGB32.blue((int)packed);
            this.setColor(new Vector3f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f));
            this.setBeamTarget(new BlockPos(ax, this.targetPos.getY(), az));
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.targetPos != null) {
            tag.put("TargetPos", NbtUtils.writeBlockPos((BlockPos)this.targetPos));
        }
        ExtraCodecs.VECTOR3F.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getColor()).result().ifPresent(color -> tag.put("TargetColor", color));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("TargetPos", 10)) {
            this.targetPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"TargetPos").orElse(null);
        }
        if (tag.contains("TargetColor", 10)) {
            ExtraCodecs.VECTOR3F.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("TargetColor")).result().ifPresent(this::setColor);
        }
    }

    public void setColor(Vector3f color) {
        this.getEntityData().set(DATA_COLOR, (Object)color);
    }

    public Vector3f getColor() {
        return (Vector3f)this.getEntityData().get(DATA_COLOR);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_COLOR, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        if (pSource.getEntity() instanceof EnderDragon) {
            return false;
        }
        if (!this.isRemoved() && !this.level().isClientSide) {
            this.remove(Entity.RemovalReason.KILLED);
            this.kill();
        }
        return true;
    }
}

