/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item;

import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.item.ImageData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ImageItem
extends Item {
    public static final List<ImageData> PRESETS = List.of(new ImageData((Component)Component.literal((String)"[Redacted]"), LTExtras.location("textures/images/ccfucc_banner.png"), 3.0f, 5.0f), new ImageData((Component)Component.literal((String)"Plantain Ent"), LTExtras.location("textures/images/plantain_ent.png"), 2.5f, 3.0f), new ImageData((Component)Component.literal((String)"Manatee"), LTExtras.location("textures/images/manatee.png"), 2.5f, 3.0f), new ImageData((Component)Component.literal((String)"Shoebill"), LTExtras.location("textures/images/shoebill.png"), 2.5f, 3.0f), new ImageData((Component)Component.literal((String)"Team Cents Poster"), LTExtras.location("textures/images/team_cents_poster.png"), 1.0f, 1.0f), new ImageData((Component)Component.literal((String)"Team No Cents Poster"), LTExtras.location("textures/images/team_no_cents_poster.png"), 1.0f, 1.0f), ImageItem.imageWithHeight("Papyrus Canary", "canary_papyrus", 3.0f, 256, 335), ImageItem.imageWithHeight("Habitat Restoration - Riverbank", "habitat_restoration_riverbank_1", 3.0f, 256, 340), ImageItem.imageWithWidth("Papyrus Gonolek", "papyrus_gonolek", 2.0f, 266, 200), ImageItem.imageWithHeight("Papyrus Harvest", "papyrus_harvest", 2.0f, 340, 256), ImageItem.imageWithWidth("Shoebill Stork", "shoebill_stork", 3.0f, 317, 256), ImageItem.imageWithWidth("White-Winged Warbler", "white_winged_warbler", 3.0f, 301, 200), ImageItem.imageWithHeight("Bird Survey", "bird_survey", 2.0f, 400, 301), ImageItem.imageWithHeight("Bridge", "bridge", 3.0f, 300, 450), ImageItem.imageWithHeight("Love Tropics", "love_tropics", 1.0f, 128, 128), ImageItem.imageWithHeight("WEA", "wea", 1.0f, 128, 128), ImageItem.imageWithWidth("Mpanga River", "mpanga_river", 2.0f, 256, 340), ImageItem.imageWithWidth("Papyrus", "papyrus", 2.0f, 341, 256), ImageItem.imageWithWidth("Papyrus Yellow Warbler", "papyrus_yellow_warbler", 1.0f, 256, 184), ImageItem.imageWithHeight("Women Holding Seeds", "women_holding_seeds", 1.0f, 300, 200));

    private static ImageData imageWithWidth(String name, String path, float blockWidth, int textureWidth, int textureHeight) {
        float blockHeight = blockWidth / (float)textureWidth * (float)textureHeight;
        return new ImageData((Component)Component.literal((String)name), LTExtras.location("textures/images/" + path + ".png"), blockWidth, blockHeight);
    }

    private static ImageData imageWithHeight(String name, String path, float blockHeight, int textureWidth, int textureHeight) {
        float blockWidth = blockHeight / (float)textureHeight * (float)textureWidth;
        return new ImageData((Component)Component.literal((String)name), LTExtras.location("textures/images/" + path + ".png"), blockWidth, blockHeight);
    }

    public ImageItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        super.appendHoverText(stack, context, lines, flag);
        ImageData image = (ImageData)stack.get(ExtraDataComponents.IMAGE);
        if (image != null && image.name().isPresent()) {
            lines.add((Component)image.name().get().copy().withStyle(ChatFormatting.GRAY));
        }
    }
}

