/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item;

import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.client.map.ClientMapManager;
import com.lovetropics.extras.data.poi.MapConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TropicMapItem
extends Item {
    public TropicMapItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Holder map = (Holder)itemStack.get(ExtraDataComponents.MAP);
        if (level.isClientSide() && map != null) {
            ClientMapManager.openScreen(player, (Holder<MapConfig>)map);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, context, tooltipComponents, tooltipFlag);
        Holder map = (Holder)itemStack.get(ExtraDataComponents.MAP);
        if (map != null) {
            tooltipComponents.add((Component)ComponentUtils.mergeStyles((MutableComponent)((MapConfig)map.value()).description().copy(), (Style)Style.EMPTY.withColor(ChatFormatting.GRAY)));
        }
    }
}

