/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin;

import com.lovetropics.extras.block.entity.MobControllerBlockEntity;
import com.lovetropics.extras.entity.ExtendedCreatureEntity;
import com.lovetropics.extras.entity.ai.MoveBackToOriginGoal;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={PathfinderMob.class})
public abstract class CreatureEntityMixin
extends Mob
implements ExtendedCreatureEntity {
    private boolean theresNoPlaceLikeHome;
    @Nullable
    private Vec3 homePos;
    private int homeRange;

    protected CreatureEntityMixin(EntityType<? extends Mob> type, Level worldIn) {
        super(type, worldIn);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("TheresNoPlaceLikeHome")) {
            this.theresNoPlaceLikeHome = nbt.getBoolean("TheresNoPlaceLikeHome");
            if (nbt.contains("HomePos")) {
                ListTag posTag = nbt.getList("HomePos", 6);
                this.homePos = new Vec3(posTag.getDouble(0), posTag.getDouble(1), posTag.getDouble(2));
            } else {
                this.homePos = this.position();
            }
            int n = this.homeRange = nbt.contains("HomeRange") ? nbt.getInt("HomeRange") : 20;
            if (this.theresNoPlaceLikeHome) {
                this.goalSelector.addGoal(0, (Goal)new MoveBackToOriginGoal((PathfinderMob)this, 1.0, this.homePos, this.homeRange));
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (this.theresNoPlaceLikeHome) {
            nbt.putBoolean("TheresNoPlaceLikeHome", this.theresNoPlaceLikeHome);
            nbt.putInt("HomeRange", this.homeRange);
            ListTag pos = new ListTag();
            pos.add(0, (Tag)DoubleTag.valueOf((double)this.homePos.x()));
            pos.add(1, (Tag)DoubleTag.valueOf((double)this.homePos.y()));
            pos.add(2, (Tag)DoubleTag.valueOf((double)this.homePos.z()));
            nbt.put("HomePos", (Tag)pos);
        }
    }

    @Override
    public void linkToBlockEntity(MobControllerBlockEntity controller) {
        BlockPos pos = controller.getBlockPos();
        this.theresNoPlaceLikeHome = true;
        this.homePos = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        this.homeRange = 32;
    }
}

