/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin.client.perf;

import com.lovetropics.extras.perf.ChunkRendererExt;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SectionRenderDispatcher.RenderSection.class})
public abstract class ChunkRenderMixin
implements ChunkRendererExt {
    @Shadow
    @Final
    private BlockPos.MutableBlockPos[] relativeOrigins;
    @Unique
    private boolean neighborChunksLoaded;

    @Shadow
    protected abstract double getDistToPlayerSqr();

    @Shadow
    protected abstract boolean doesChunkExistAt(BlockPos var1);

    @Overwrite
    public boolean hasAllNeighbors() {
        if (this.neighborChunksLoaded) {
            return true;
        }
        if (this.getDistToPlayerSqr() > 576.0) {
            this.neighborChunksLoaded = this.doesChunkExistAt((BlockPos)this.relativeOrigins[Direction.WEST.ordinal()]) && this.doesChunkExistAt((BlockPos)this.relativeOrigins[Direction.NORTH.ordinal()]) && this.doesChunkExistAt((BlockPos)this.relativeOrigins[Direction.EAST.ordinal()]) && this.doesChunkExistAt((BlockPos)this.relativeOrigins[Direction.SOUTH.ordinal()]);
            return this.neighborChunksLoaded;
        }
        return true;
    }

    @Inject(method={"setOrigin"}, at={@At(value="HEAD")})
    private void setOrigin(int x, int y, int z, CallbackInfo ci) {
        this.neighborChunksLoaded = false;
    }

    @Override
    public void extras$markNeighborChunksUnloaded() {
        this.neighborChunksLoaded = false;
    }
}

