/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.network.message;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.client.world_effect.SkyColorEffectHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClientboundSetSkyColorPacket(int color, int fadeLength) implements CustomPacketPayload
{
    private static final int CLEAR = Integer.MIN_VALUE;
    public static final StreamCodec<ByteBuf, ClientboundSetSkyColorPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClientboundSetSkyColorPacket::color, (StreamCodec)ByteBufCodecs.VAR_INT, ClientboundSetSkyColorPacket::fadeLength, ClientboundSetSkyColorPacket::new);
    public static final CustomPacketPayload.Type<ClientboundSetSkyColorPacket> TYPE = new CustomPacketPayload.Type(LTExtras.location("set_sky_color"));

    public static ClientboundSetSkyColorPacket clear(int fadeLength) {
        return new ClientboundSetSkyColorPacket(Integer.MIN_VALUE, fadeLength);
    }

    public static void handle(ClientboundSetSkyColorPacket packet, IPayloadContext ctx) {
        if (packet.color == Integer.MIN_VALUE) {
            SkyColorEffectHandler.clear(packet.fadeLength);
        } else {
            SkyColorEffectHandler.apply(packet.color, packet.fadeLength);
        }
    }

    public CustomPacketPayload.Type<ClientboundSetSkyColorPacket> type() {
        return TYPE;
    }
}

