/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.registry;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.data.poi.MapConfig;
import com.lovetropics.extras.data.poi.PoiConfig;
import com.lovetropics.extras.world_effect.WorldEffect;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

@EventBusSubscriber(modid="ltextras", bus=EventBusSubscriber.Bus.MOD)
public class ExtraRegistries {
    public static final ResourceKey<Registry<Collectible>> COLLECTIBLE = ExtraRegistries.createKey("collectible");
    public static final ResourceKey<Registry<MapConfig>> MAP = ExtraRegistries.createKey("map");
    public static final ResourceKey<Registry<WorldEffect>> WORLD_EFFECT = ExtraRegistries.createKey("world_effect");
    public static final ResourceKey<Registry<PoiConfig>> POI = ExtraRegistries.createKey("poi");

    @SubscribeEvent
    public static void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(COLLECTIBLE, Collectible.DIRECT_CODEC, Collectible.DIRECT_CODEC);
        event.dataPackRegistry(MAP, MapConfig.DIRECT_CODEC, MapConfig.DIRECT_CODEC);
    }

    private static <T> ResourceKey<Registry<T>> createKey(String name) {
        return ResourceKey.createRegistryKey((ResourceLocation)LTExtras.location(name));
    }
}

