/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.rejoiner;

import com.lovetropics.extras.ExtrasConfig;
import com.lovetropics.extras.network.message.ClientboundSetAutoRejoinIntent;
import com.lovetropics.extras.rejoiner.AutoRejoinIntent;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="ltextras")
public class ServerAutoRejoinHandler {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stop").then(Commands.literal((String)"restartClient").executes(context -> ServerAutoRejoinHandler.stopWithIntent((CommandContext<CommandSourceStack>)context, AutoRejoinIntent.RESTART_SERVER_AND_CLIENT)))).then(Commands.literal((String)"permanently").executes(context -> ServerAutoRejoinHandler.stopWithIntent((CommandContext<CommandSourceStack>)context, AutoRejoinIntent.SHUT_DOWN_PERMANENT))));
    }

    private static int stopWithIntent(CommandContext<CommandSourceStack> context, AutoRejoinIntent restartServerAndClient) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        ServerAutoRejoinHandler.broadcastRejoinIntent(server, restartServerAndClient);
        server.halt(false);
        return 1;
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AutoRejoinIntent intent = (Boolean)ExtrasConfig.CLIENT_AUTO_REJOIN.get() != false ? AutoRejoinIntent.ENABLE : AutoRejoinIntent.DISABLE;
            player2.connection.send((CustomPacketPayload)new ClientboundSetAutoRejoinIntent(intent));
        }
    }

    public static void broadcastRejoinIntent(MinecraftServer server, AutoRejoinIntent intent) {
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            player.connection.send((CustomPacketPayload)new ClientboundSetAutoRejoinIntent(intent));
        }
    }
}

