/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.world_effect;

import com.lovetropics.extras.world_effect.WorldEffect;
import com.lovetropics.extras.world_effect.WorldEffectType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;

public record CompositeWorldEffect(List<WorldEffect> effects) implements WorldEffect
{
    public static final Codec<CompositeWorldEffect> CODEC = WorldEffect.CODEC.listOf().xmap(CompositeWorldEffect::new, CompositeWorldEffect::effects);
    public static final MapCodec<CompositeWorldEffect> MAP_CODEC = CODEC.fieldOf("effects");

    @Override
    public void apply(ServerPlayer player, boolean immediate) {
        for (WorldEffect effect : this.effects) {
            effect.apply(player, immediate);
        }
    }

    @Override
    public void clear(ServerPlayer player, boolean immediate) {
        for (WorldEffect effect : this.effects) {
            effect.clear(player, immediate);
        }
    }

    @Override
    public WorldEffectType type() {
        return WorldEffectType.COMPOSITE;
    }
}

