/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.world_effect;

import com.lovetropics.extras.network.message.ClientboundSetSkyColorPacket;
import com.lovetropics.extras.world_effect.WorldEffect;
import com.lovetropics.extras.world_effect.WorldEffectType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FastColor;
import net.neoforged.neoforge.network.PacketDistributor;

public record SkyColorEffect(int red, int green, int blue, int fadeLength) implements WorldEffect
{
    private static final Codec<Integer> COLOR_COMPONENT_CODEC = ExtraCodecs.intRange((int)0, (int)255);
    public static final MapCodec<SkyColorEffect> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)COLOR_COMPONENT_CODEC.fieldOf("red").forGetter(SkyColorEffect::red), (App)COLOR_COMPONENT_CODEC.fieldOf("green").forGetter(SkyColorEffect::green), (App)COLOR_COMPONENT_CODEC.fieldOf("blue").forGetter(SkyColorEffect::blue), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("fade_length", (Object)20).forGetter(SkyColorEffect::fadeLength)).apply((Applicative)i, SkyColorEffect::new));

    @Override
    public void apply(ServerPlayer player, boolean immediate) {
        int color = FastColor.ARGB32.color((int)0, (int)this.red, (int)this.green, (int)this.blue);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundSetSkyColorPacket(color, immediate ? 0 : this.fadeLength), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void clear(ServerPlayer player, boolean immediate) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)ClientboundSetSkyColorPacket.clear(this.fadeLength), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public WorldEffectType type() {
        return WorldEffectType.SKY_COLOR;
    }
}

