/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.world_effect;

import com.lovetropics.extras.data.Named;
import com.lovetropics.extras.data.SimpleDataPackLister;
import com.lovetropics.extras.registry.ExtraRegistries;
import com.lovetropics.extras.world_effect.WorldEffect;
import com.lovetropics.extras.world_effect.WorldEffectManager;
import com.lovetropics.lib.codec.CodecRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(modid="ltextras")
public class WorldEffectConfigs {
    public static final CodecRegistry<ResourceLocation, Named<WorldEffect>> REGISTRY = CodecRegistry.resourceLocationKeys();
    private static final SimpleDataPackLister<WorldEffect> LISTER = new SimpleDataPackLister<WorldEffect>("world_effects", ExtraRegistries.WORLD_EFFECT, WorldEffect.CODEC);

    @SubscribeEvent
    public static void addReloadListener(AddReloadListenerEvent event) {
        RegistryAccess registries = event.getRegistryAccess();
        event.addListener((stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> ((CompletableFuture)LISTER.load(registries, resourceManager, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenAcceptAsync(effects -> {
            REGISTRY.clear();
            effects.forEach(holder -> REGISTRY.register((Object)holder.id(), holder));
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                WorldEffectManager.reload(server);
            }
        }, gameExecutor));
    }
}

