/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras;

import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.client.item.CollectibleCompassAngle;
import com.lovetropics.extras.client.item.HasUnseenCollectible;
import com.lovetropics.extras.entity.ExtraEntities;
import com.lovetropics.extras.item.CleaningItemFrameItem;
import com.lovetropics.extras.item.CollectibleBasketItem;
import com.lovetropics.extras.item.CollectibleCompassItem;
import com.lovetropics.extras.item.CustomBootsItem;
import com.lovetropics.extras.item.EntityWandItem;
import com.lovetropics.extras.item.ForkliftSpawnEggItem;
import com.lovetropics.extras.item.HighHeelsItem;
import com.lovetropics.extras.item.ImageData;
import com.lovetropics.extras.item.ImageItem;
import com.lovetropics.extras.item.InviteItem;
import com.lovetropics.extras.item.TropicMapItem;
import com.lovetropics.extras.item.WalkSound;
import com.lovetropics.extras.item.WaterCoolerSpawnEggItem;
import com.lovetropics.extras.model_modifer.ModelModifierType;
import com.lovetropics.extras.registry.ExtraRegistries;
import com.lovetropics.extras.sounds.ExtraSounds;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.generators.RegistrateItemModelGenerator;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.RangeSelectItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.DisplayContext;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.common.EventBusSubscriber;

public class ExtraItems {
    private static final Registrate REGISTRATE = LTExtras.registrate();
    public static final FoodProperties PC_ENERGY_FOOD = new FoodProperties.Builder().nutrition(2).saturationModifier(0.2f).alwaysEdible().build();
    public static final FoodProperties TROPI_COOKIES_FOOD = new FoodProperties.Builder().nutrition(3).saturationModifier(0.2f).alwaysEdible().build();
    public static final FoodProperties GEGY_CHIPS_FOOD = new FoodProperties.Builder().nutrition(2).saturationModifier(0.1f).alwaysEdible().build();
    public static final Consumable PC_ENERGY_CONSUME = Consumables.defaultDrink().onConsume((ConsumeEffect)new ApplyStatusEffectsConsumeEffect(new MobEffectInstance(MobEffects.SPEED, 200, 0))).build();
    private static final ResourceKey<EquipmentAsset> PLACEHOLDER_EQUIPMENT_ASSET = EquipmentAssets.LEATHER;
    public static final ItemEntry<EntityWandItem> ENTITY_WAND = REGISTRATE.item("entity_wand", EntityWandItem::new).properties(p -> p.stacksTo(1)).register();
    public static final ItemEntry<Item> TROPICOIN = REGISTRATE.item("tropicoin", Item::new).lang("TropiCoin").register();
    public static final ItemEntry<Item> BLUE_KEY = REGISTRATE.item("blue_key", Item::new).register();
    public static final ItemEntry<Item> RED_KEY = REGISTRATE.item("red_key", Item::new).register();
    public static final ItemEntry<Item> WHITE_KEY = REGISTRATE.item("white_key", Item::new).register();
    public static final ItemEntry<Item> YELLOW_KEY = REGISTRATE.item("yellow_key", Item::new).register();
    public static final ItemEntry<Item> DENTED_CAN = REGISTRATE.item("dented_can", Item::new).register();
    public static final ItemEntry<Item> FILLED_LUBRICANT_JAR = REGISTRATE.item("filled_lubricant_jar", Item::new).register();
    public static final ItemEntry<Item> LUBRICANT_JAR = REGISTRATE.item("lubricant_jar", Item::new).register();
    public static final ItemEntry<Item> PAPER_BAG = REGISTRATE.item("paper_bag", Item::new).register();
    public static final ItemEntry<Item> PC_ENERGY = REGISTRATE.item("pc_energy", Item::new).properties(p -> p.food(PC_ENERGY_FOOD).component(DataComponents.CONSUMABLE, (Object)PC_ENERGY_CONSUME)).lang("PCEnergy").register();
    public static final ItemEntry<Item> TROPI_COOKIES = REGISTRATE.item("tropi_cookies", Item::new).properties(p -> p.food(TROPI_COOKIES_FOOD).component(DataComponents.CONSUMABLE, (Object)Consumables.DEFAULT_FOOD)).register();
    public static final ItemEntry<Item> GEGY_POTATO_CHIPS = REGISTRATE.item("gegy_potato_chips", Item::new).properties(p -> p.food(GEGY_CHIPS_FOOD).component(DataComponents.CONSUMABLE, (Object)Consumables.DEFAULT_FOOD)).lang("Gegy's Potato Chips").register();
    public static final ItemEntry<Item> OIL_CAN = REGISTRATE.item("oil_can", Item::new).register();
    public static final ItemEntry<Item> ORANGE_GLASSES = ExtraItems.sunglasses("orange_glasses").register();
    public static final ItemEntry<Item> BLUE_GLASSES = ExtraItems.sunglasses("blue_glasses").register();
    public static final ItemEntry<Item> GREEN_GLASSES = ExtraItems.sunglasses("green_glasses").register();
    public static final ItemEntry<Item> WRENCH = REGISTRATE.item("wrench", Item::new).lang("Wrench").register();
    public static final ItemEntry<Item> STEERING_WHEEL = REGISTRATE.item("steering_wheel", Item::new).lang("Steering Wheel").register();
    public static final ItemEntry<Item> PUMP = REGISTRATE.item("pump", Item::new).lang("Pump").register();
    public static final ItemEntry<Item> PLASTIC_SHEETS = REGISTRATE.item("plastic_sheets", Item::new).lang("Plastic Sheets").register();
    public static final ItemEntry<Item> HOSE = REGISTRATE.item("hose", Item::new).lang("Hose").register();
    public static final ItemEntry<Item> GEARBOX = REGISTRATE.item("gearbox", Item::new).lang("Gearbox").register();
    public static final ItemEntry<Item> FORKLIFT_FORKS = REGISTRATE.item("forklift_forks", Item::new).lang("Forklift Forks").register();
    public static final ItemEntry<Item> FOOT_PEDAL = REGISTRATE.item("foot_pedal", Item::new).lang("Foot Pedal").register();
    public static final ItemEntry<Item> BOLT = REGISTRATE.item("bolt", Item::new).lang("Bolt").register();
    public static final ItemEntry<Item> BATTERY = REGISTRATE.item("battery", Item::new).lang("Battery").register();
    public static final ItemEntry<CollectibleBasketItem> COLLECTIBLE_BASKET = REGISTRATE.item("collectible_basket", CollectibleBasketItem::new).properties(p -> p.stacksTo(1)).model(() -> Models::generateCollectibleBasket).register();
    public static final ItemEntry<CollectibleCompassItem> COLLECTIBLE_COMPASS = REGISTRATE.item("collectible_compass", CollectibleCompassItem::new).properties(p -> p.stacksTo(1)).model(() -> Models::generateCollectibleCompass).register();
    public static final ItemEntry<ImageItem> IMAGE = REGISTRATE.item("image", ImageItem::new).tab(LTExtras.TAB_KEY, (ctx, modifier) -> {
        for (ImageData preset : ImageItem.PRESETS) {
            ItemStack stack = new ItemStack((ItemLike)ctx.get());
            stack.set(ExtraDataComponents.IMAGE, (Object)preset);
            modifier.accept(stack);
        }
    }).register();
    public static final ItemEntry<InviteItem> INVITE = REGISTRATE.item("invite", InviteItem::new).tab(LTExtras.TAB_KEY, (ctx, modifier) -> {
        for (ImageData preset : InviteItem.PRESETS) {
            ItemStack stack = new ItemStack((ItemLike)ctx.get());
            stack.set(ExtraDataComponents.IMAGE, (Object)preset);
            modifier.accept(stack);
        }
    }).register();
    public static final ItemEntry<Item> QUEST = REGISTRATE.item("quest", Item::new).register();
    public static final ItemEntry<TropicMapItem> TROPICAL_MAP = REGISTRATE.item("tropical_map", TropicMapItem::new).initialProperties(() -> new Item.Properties().stacksTo(1)).tab(LTExtras.TAB_KEY, (ctx, modifier) -> {
        HolderLookup.RegistryLookup maps = modifier.getParameters().holders().lookupOrThrow(ExtraRegistries.MAP);
        maps.listElements().forEach(map -> {
            ItemStack stack = new ItemStack((ItemLike)ctx.get());
            stack.set(ExtraDataComponents.MAP, map);
            modifier.accept(stack);
        });
    }).defaultModel().register();
    public static final ItemEntry<Item> HARD_HAT = REGISTRATE.item("hard_hat", Item::new).properties(p -> p.stacksTo(1).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.HEAD).setEquipSound(SoundEvents.ARMOR_EQUIP_GENERIC).build())).model(() -> (ctx, prov) -> prov.createWithExistingModel((Item)ctx.get(), LTExtras.location("item/hard_hat"))).register();
    public static final ItemEntry<Item> REFLECTIVE_VEST = REGISTRATE.item("reflective_vest", Item::new).properties(p -> p.stacksTo(1).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.CHEST).setEquipSound(SoundEvents.ARMOR_EQUIP_LEATHER).setAsset(ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)LTExtras.location("reflective_vest"))).build())).defaultModel().register();
    public static final ItemEntry<HighHeelsItem> HIGH_HEELS = REGISTRATE.item("high_heels", HighHeelsItem::new).properties(p -> p.stacksTo(1).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.FEET).setAsset(PLACEHOLDER_EQUIPMENT_ASSET).build()).component(ExtraDataComponents.WALK_ANIMATION, List.of(ModelModifierType.FABULOUS)).component(ExtraDataComponents.WALK_SOUND, (Object)WalkSound.builder().soundEvent(ExtraSounds.HEELS_STEP).cooldown(0.9f).volume(0.5f).build()).component(ExtraDataComponents.ADJUST_HEIGHT, (Object)Float.valueOf(0.2f))).clientExtension(() -> HighHeelsItem.ClientExtensions::new).defaultModel().register();
    public static final ItemEntry<CustomBootsItem> BIG_BOOT = REGISTRATE.item("big_boot", CustomBootsItem::new).properties(p -> p.stacksTo(1).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.FEET).setAsset(PLACEHOLDER_EQUIPMENT_ASSET).build()).component(ExtraDataComponents.WALK_ANIMATION, List.of(ModelModifierType.STIFF_LEGS, ModelModifierType.HOP_WALK)).component(ExtraDataComponents.ADJUST_HEIGHT, (Object)Float.valueOf(0.45f))).model(() -> (ctx, prov) -> prov.createWithExistingModel((Item)ctx.get(), LTExtras.location("item/big_boot"))).register();
    public static final ItemEntry<Item> FORKLIFT_CERTIFICATION = REGISTRATE.item("forklift_certification", Item::new).register();
    public static final ItemEntry<ForkliftSpawnEggItem> FORKLIFT_SPAWN_EGG = REGISTRATE.item("forklift_spawn_egg", ForkliftSpawnEggItem::new).register();
    public static final ItemEntry<WaterCoolerSpawnEggItem> WATER_COOLER_SPAWN_EGG = REGISTRATE.item("water_cooler_spawn_egg", WaterCoolerSpawnEggItem::new).register();
    public static final ItemEntry<SpawnEggItem> AMAZON_RIVER_DOLPHIN_SPAWN_EGG = REGISTRATE.item("amazon_river_dolphin_spawn_egg", p -> new SpawnEggItem((EntityType)ExtraEntities.AMAZON_RIVER_DOLPHIN.get(), p)).register();
    public static final ItemEntry<SpawnEggItem> GLASS_FROG_SPAWN_EGG = REGISTRATE.item("glass_frog_spawn_egg", p -> new SpawnEggItem((EntityType)ExtraEntities.GLASS_FROG.get(), p)).register();
    public static final ItemEntry<CleaningItemFrameItem> CLEANING_ITEM_FRAME = REGISTRATE.item("cleaning_item_frame", CleaningItemFrameItem::new).register();
    public static final ItemEntry<Item> BLOODWOOD_SAP = REGISTRATE.item("bloodwood_sap", Item::new).register();
    public static final ItemEntry<Item> GUAYUSA_LEAF = REGISTRATE.item("guayusa_leaf", Item::new).register();
    public static final ItemEntry<Item> GUAYUSA_TEA = REGISTRATE.item("guayusa_tea", Item::new).register();

    private static ItemBuilder<Item, Registrate> sunglasses(String name) {
        return REGISTRATE.item(name, Item::new).properties(p -> p.stacksTo(1).equippable(EquipmentSlot.HEAD)).model(() -> Models::generateGlasses);
    }

    public static void init() {
    }

    @EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
    private static class Models {
        public static final ModelTemplate GLASSES_EQUIPPED_TEMPLATE = ModelTemplates.createItem((String)LTExtras.location("template_glasses_equipped").toString(), (String)"_equipped", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0});

        private Models() {
        }

        private static void generateForkliftCertification(DataGenContext<Item, CollectibleBasketItem> ctx, RegistrateItemModelGenerator prov) {
            prov.itemModelOutput.accept((Item)ctx.get(), ItemModelUtils.conditional((ConditionalItemModelProperty)new HasUnseenCollectible(), (ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)prov.createFlatItemModel((Item)ctx.get(), "_unseen", ModelTemplates.FLAT_ITEM)), (ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)prov.createFlatItemModel((Item)ctx.get(), ModelTemplates.FLAT_ITEM))));
        }

        private static void generateCollectibleBasket(DataGenContext<Item, CollectibleBasketItem> ctx, RegistrateItemModelGenerator prov) {
            prov.itemModelOutput.accept((Item)ctx.get(), ItemModelUtils.conditional((ConditionalItemModelProperty)new HasUnseenCollectible(), (ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)prov.createFlatItemModel((Item)ctx.get(), "_unseen", ModelTemplates.FLAT_ITEM)), (ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)prov.createFlatItemModel((Item)ctx.get(), ModelTemplates.FLAT_ITEM))));
        }

        private static void generateGlasses(DataGenContext<Item, Item> ctx, RegistrateItemModelGenerator prov) {
            Models.generateHeadEquippable(ctx, prov, ModelTemplates.FLAT_ITEM.create((Item)ctx.get(), TextureMapping.layer0((Item)((Item)ctx.get())), prov.modelOutput), GLASSES_EQUIPPED_TEMPLATE.create((Item)ctx.get(), TextureMapping.layer0((ResourceLocation)TextureMapping.getItemTexture((Item)((Item)ctx.get()), (String)"_equipped")), prov.modelOutput));
        }

        private static void generateHeadEquippable(DataGenContext<Item, Item> ctx, RegistrateItemModelGenerator prov, ResourceLocation model, ResourceLocation equippedModel) {
            prov.itemModelOutput.accept((Item)ctx.get(), ItemModelUtils.select((SelectItemModelProperty)new DisplayContext(), (ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)model), (SelectItemModel.SwitchCase[])new SelectItemModel.SwitchCase[]{ItemModelUtils.when(List.of(ItemDisplayContext.HEAD), (ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)equippedModel))}));
        }

        private static void generateCustomCompass(DataGenContext<Item, CollectibleCompassItem> ctx, RegistrateItemModelGenerator prov, RangeSelectItemModelProperty angle) {
            ItemModel.Unbaked baseModel = ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)Items.COMPASS, (String)"_16"));
            ArrayList<RangeSelectItemModel.Entry> modelByAngle = new ArrayList<RangeSelectItemModel.Entry>();
            modelByAngle.add(ItemModelUtils.override((ItemModel.Unbaked)baseModel, (float)0.0f));
            for (int i = 1; i < 32; ++i) {
                int threshold = Mth.positiveModulo((int)(i - 16), (int)32);
                modelByAngle.add(ItemModelUtils.override((ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)Items.COMPASS, (String)String.format(Locale.ROOT, "_%02d", threshold))), (float)((float)i - 0.5f)));
            }
            modelByAngle.add(ItemModelUtils.override((ItemModel.Unbaked)baseModel, (float)31.5f));
            prov.itemModelOutput.accept((Item)ctx.get(), ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)angle, (float)32.0f, modelByAngle));
        }

        private static void generateCollectibleCompass(DataGenContext<Item, CollectibleCompassItem> ctx, RegistrateItemModelGenerator prov) {
            Models.generateCustomCompass(ctx, prov, new CollectibleCompassAngle());
        }
    }
}

