/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras;

import com.lovetropics.extras.ExtraBlocks;
import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.ExtraLangKeys;
import com.lovetropics.extras.ExtraTags;
import com.lovetropics.extras.ExtrasConfig;
import com.lovetropics.extras.client.ClientPlayerForkliftHUD;
import com.lovetropics.extras.client.ClientPlayerSensorEffects;
import com.lovetropics.extras.client.command.NameTagModeCommand;
import com.lovetropics.extras.client.entity.model.AmazonRiverDolphinModel;
import com.lovetropics.extras.client.entity.model.ForkliftModel;
import com.lovetropics.extras.client.entity.model.GlassFrogModel;
import com.lovetropics.extras.client.entity.model.HighHeelsModel;
import com.lovetropics.extras.client.entity.model.RaveKoaModel;
import com.lovetropics.extras.client.entity.model.SpinningSignModel;
import com.lovetropics.extras.client.entity.model.WaterCoolerModel;
import com.lovetropics.extras.client.keybinds.ForkliftKeybinds;
import com.lovetropics.extras.client.particle.ExtraParticles;
import com.lovetropics.extras.collectible.CollectibleCommand;
import com.lovetropics.extras.collectible.GenerateCollectibleCommand;
import com.lovetropics.extras.command.ExtraCommandArguments;
import com.lovetropics.extras.command.GenerateCommand;
import com.lovetropics.extras.command.HandCommand;
import com.lovetropics.extras.command.ListScoreboardCommand;
import com.lovetropics.extras.command.PoiCommand;
import com.lovetropics.extras.command.SetMaxPlayersCommand;
import com.lovetropics.extras.command.TpCommand;
import com.lovetropics.extras.command.WarpCommand;
import com.lovetropics.extras.data.attachment.ExtraAttachments;
import com.lovetropics.extras.data.spawnitems.SpawnItemsCommand;
import com.lovetropics.extras.effect.ExtraEffects;
import com.lovetropics.extras.effect.PropaguledEffect;
import com.lovetropics.extras.entity.ExtraEntities;
import com.lovetropics.extras.entity.ExtraSerializers;
import com.lovetropics.extras.model_modifer.ModelModifierCommand;
import com.lovetropics.extras.mounts.MountCommand;
import com.lovetropics.extras.placeholder.ExtraPlaceholders;
import com.lovetropics.extras.sounds.ExtraSounds;
import com.lovetropics.extras.techstack.VideoImporter;
import com.lovetropics.extras.world_effect.WorldEffectCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.providers.GeneratorType;
import com.tterrag.registrate.providers.ProviderType;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;

@Mod(value="ltextras")
public class LTExtras {
    public static final String MODID = "ltextras";
    private static final ResourceLocation TAB_ID = LTExtras.location("ltextras");
    public static final ResourceKey<CreativeModeTab> TAB_KEY = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)TAB_ID);
    @Nullable
    private static Registrate REGISTRATE = null;
    public static final Holder<Attribute> FRICTION = LTExtras.registrate().simple("friction", Registries.ATTRIBUTE, () -> new RangedAttribute("ltextras.friction", 1.0, 0.0, 1024.0).setSyncable(true));
    private static final Pattern QUALIFIER = Pattern.compile("-\\w+\\+\\d+");

    public static Registrate registrate() {
        if (REGISTRATE == null) {
            REGISTRATE = (Registrate)Registrate.create((String)MODID).defaultCreativeTab(TAB_KEY);
        }
        return REGISTRATE;
    }

    public LTExtras(IEventBus modBus, ModContainer container) {
        ExtraBlocks.init();
        ExtraItems.init();
        ExtraEntities.init();
        ExtraPlaceholders.init();
        ExtraParticles.REGISTER.register(modBus);
        ExtraEffects.REGISTER.register(modBus);
        ExtraDataComponents.REGISTER.register(modBus);
        ExtraAttachments.REGISTER.register(modBus);
        ExtraSounds.REGISTER.register(modBus);
        ExtraSerializers.REGISTER.register(modBus);
        ExtraCommandArguments.REGISTER.register(modBus);
        NeoForge.EVENT_BUS.addListener(this::onRegisterCommands);
        NeoForge.EVENT_BUS.addListener(this::onRegisterClientCommands);
        NeoForge.EVENT_BUS.addListener(VideoImporter.get()::onServerStarted);
        modBus.addListener(this::onModifyAttributes);
        ExtraLangKeys.init(LTExtras.registrate());
        ((Registrate)((Registrate)((Registrate)LTExtras.registrate().addDataGenerator((GeneratorType)ProviderType.LANG, p -> {
            p.add((MobEffect)ExtraEffects.FISH_EYE.get(), "Fish Eye");
            p.add((MobEffect)ExtraEffects.PROPAGULED.get(), "Propaguled!");
            p.add("toast.collectible.title", "New Collectible!");
            p.add("toast.collectible.item", " + %s");
            p.add("spawnitems.set_not_restorable", "The spawn item set %s cannot be restored!");
            p.add("spawnitems.unknown_set", "Unknown spawn item set: %s");
            p.add("spawnitems.restored_successfully", "Items restored!");
            p.add("ltextras.friction", "Friction");
            String keybindBase = "key.ltextras.";
            p.add("key.categories.ltextras.lobby", "Forklift Controls");
            p.add(keybindBase + "forklift_raise", "Raise Forklift");
            p.add(keybindBase + "forklift_lower", "Lower Forklift");
            p.add(keybindBase + "forklift_drift", "Drift");
            p.add(keybindBase + "eject_fork_riders", "Eject Riders");
            TpCommand.addTranslations(p);
            WarpCommand.addTranslations(p);
            ExtraEffects.MODEL_EFFECTS.forEach((modifier, effect) -> p.add((MobEffect)effect.value(), modifier.getEffectName()));
        })).addDataGenerator((GeneratorType)ProviderType.BLOCK_TAGS, block -> block.tag(ExtraTags.Blocks.PLUMBERS_TNT_EXPLODES).add((Object[])new Block[]{Blocks.MUD, Blocks.PACKED_MUD, Blocks.DIRT}).add(TagEntry.optionalElement((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tropicraft", (String)"mud"))).add(TagEntry.optionalElement((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tropicraft", (String)"mud_with_pianguas"))))).addDataGenerator((GeneratorType)ProviderType.ITEM_TAGS, item -> item.tag(ExtraTags.Items.HONIES).add((Object)Items.HONEY_BOTTLE))).generic(TAB_ID.getPath(), Registries.CREATIVE_MODE_TAB, () -> CreativeModeTab.builder().title((Component)LTExtras.registrate().addLang("itemGroup", TAB_ID, "LTExtras")).icon(() -> ExtraBlocks.BUOY.asStack()).build()).build();
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ExtrasConfig.COMMON_CONFIG);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ExtrasConfig.CLIENT_CONFIG);
    }

    public static String getCompatVersion() {
        return LTExtras.getCompatVersion(((ModContainer)ModList.get().getModContainerById(MODID).orElseThrow(IllegalStateException::new)).getModInfo().getVersion().toString());
    }

    private static String getCompatVersion(String fullVersion) {
        return QUALIFIER.matcher(fullVersion).replaceAll("");
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CommandBuildContext buildContext = event.getBuildContext();
        SetMaxPlayersCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        GenerateCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        ListScoreboardCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        CollectibleCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
        GenerateCollectibleCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
        SpawnItemsCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        TpCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        WorldEffectCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        WarpCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        PoiCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
        ModelModifierCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        MountCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
        HandCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    private void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        NameTagModeCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    private void onModifyAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, FRICTION);
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @EventBusSubscriber(modid="ltextras", value={Dist.CLIENT})
    public static class ClientSetup {
        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(RaveKoaModel.LAYER_LOCATION, RaveKoaModel::createBodyLayer);
            event.registerLayerDefinition(HighHeelsModel.LAYER_LOCATION, HighHeelsModel::createLayer);
            event.registerLayerDefinition(ForkliftModel.LAYER_LOCATION, ForkliftModel::createBodyLayer);
            event.registerLayerDefinition(WaterCoolerModel.LAYER_LOCATION, WaterCoolerModel::createBodyLayer);
            event.registerLayerDefinition(SpinningSignModel.LAYER_LOCATION, SpinningSignModel::createBodyLayer);
            event.registerLayerDefinition(AmazonRiverDolphinModel.LAYER, AmazonRiverDolphinModel::createBodyLayer);
            event.registerLayerDefinition(AmazonRiverDolphinModel.BABY_LAYER, () -> AmazonRiverDolphinModel.createBodyLayer().apply(AmazonRiverDolphinModel.BABY_TRANSFORMER));
            event.registerLayerDefinition(GlassFrogModel.LAYER, GlassFrogModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void registerGuiLayers(RegisterGuiLayersEvent event) {
            ClientPlayerSensorEffects.registerGuiLayers(event);
            ClientPlayerForkliftHUD.registerGuiLayers(event);
        }

        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent event) {
            ForkliftKeybinds.init();
        }

        @SubscribeEvent
        public static void registerMobEffectExtensions(RegisterClientExtensionsEvent event) {
            event.registerMobEffect((IClientMobEffectExtensions)new PropaguledEffect.ClientExtensions(), new Holder[]{ExtraEffects.PROPAGULED});
        }
    }
}

