/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.mojang.serialization.MapCodec;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class AdjustableLampBlock
extends RedstoneLampBlock {
    public static final MapCodec<RedstoneLampBlock> CODEC = AdjustableLampBlock.simpleCodec(AdjustableLampBlock::new);
    public static final IntegerProperty LIGHT_LEVEL = BlockStateProperties.LEVEL;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = blockState -> (Boolean)blockState.getValue((Property)LIT) != false ? (Integer)blockState.getValue((Property)LIGHT_LEVEL) : 0;
    private static final int DEFAULT_LIGHT_LEVEL = 7;

    public MapCodec<RedstoneLampBlock> codec() {
        return CODEC;
    }

    public AdjustableLampBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(7)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean lit = context.getLevel().hasNeighborSignal(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(lit));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT}).add(new Property[]{LIGHT_LEVEL});
    }
}

