/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class ConveyorBeltBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<ConveyorBeltBlock> CODEC = ConveyorBeltBlock.simpleCodec(ConveyorBeltBlock::new);
    private static final float SPEED = 0.25f;
    private static final float CENTERING_FACTOR = 0.2f;
    private static final float THRESHOLD = 0.02f;

    public ConveyorBeltBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        ConveyorBeltBlock.moveItem(entity, (Direction)state.getValue((Property)FACING), pos);
        super.stepOn(level, pos, state, entity);
    }

    public static void moveItem(Entity entity, Direction direction, BlockPos pos) {
        double motionX;
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity item = (ItemEntity)entity;
        double dx = pos.getCenter().x() - item.getX();
        double dz = pos.getCenter().z() - item.getZ();
        double stepX = direction.getStepX();
        double stepZ = direction.getStepZ();
        boolean alongX = stepX != 0.0;
        double forwardX = stepX * 0.25;
        double forwardZ = stepZ * 0.25;
        double halfForwardX = forwardX * 0.5;
        double halfForwardZ = forwardZ * 0.5;
        boolean offCenter = Math.abs(alongX ? dz : dx) > (double)0.02f;
        double centerAdjust = (alongX ? dz : dx) * (double)0.2f;
        double d = alongX ? (offCenter ? halfForwardX : forwardX) : (motionX = offCenter ? centerAdjust : forwardX);
        double motionZ = alongX ? (offCenter ? centerAdjust : forwardZ) : (offCenter ? halfForwardZ : forwardZ);
        entity.setDeltaMovement(motionX, 0.0, motionZ);
    }
}

