/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="ltextras")
public class CustomSeagrassBlock
extends SeagrassBlock {
    private final String scientificName;
    @Nullable
    private final Supplier<Supplier<? extends TallSeagrassBlock>> tall;

    public CustomSeagrassBlock(BlockBehaviour.Properties properties, String scientificName, @Nullable Supplier<Supplier<? extends TallSeagrassBlock>> tall) {
        super(properties);
        this.scientificName = scientificName;
        this.tall = tall;
    }

    @SubscribeEvent
    public static void addToTooltip(ItemTooltipEvent event) {
        BlockItem blockItem;
        Item item = event.getItemStack().getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof CustomSeagrassBlock) {
            CustomSeagrassBlock seagrass = (CustomSeagrassBlock)item;
            event.getToolTip().add(Component.literal((String)seagrass.scientificName).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
        }
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (this.tall == null) {
            return;
        }
        BlockState bottomState = this.tall.get().get().defaultBlockState();
        BlockState topState = (BlockState)bottomState.setValue((Property)TallSeagrassBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
        BlockPos topPos = pos.above();
        if (level.getBlockState(topPos).is(Blocks.WATER)) {
            level.setBlock(pos, bottomState, 2);
            level.setBlock(topPos, topState, 2);
        }
    }
}

