/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GirderBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final Map<Direction.Axis, BooleanProperty> PROPS = (Map)Arrays.stream(Direction.Axis.values()).collect(Maps.toImmutableEnumMap(Function.identity(), a -> BooleanProperty.create((String)a.getName())));
    public static final Map<Direction.Axis, VoxelShape> BASE_SHAPES = ImmutableMap.builder().put((Object)Direction.Axis.X, (Object)Block.box((double)0.0, (double)3.0, (double)5.0, (double)16.0, (double)13.0, (double)11.0)).put((Object)Direction.Axis.Y, (Object)Block.box((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0)).put((Object)Direction.Axis.Z, (Object)Block.box((double)5.0, (double)3.0, (double)0.0, (double)11.0, (double)13.0, (double)16.0)).build();
    private final LazyLoadedValue<Map<BlockState, VoxelShape>> ALL_SHAPES = new LazyLoadedValue(() -> this.getStateDefinition().getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), s -> {
        VoxelShape ret = Shapes.empty();
        for (Direction.Axis a : Direction.Axis.values()) {
            if (!((Boolean)s.getValue((Property)PROPS.get(a))).booleanValue()) continue;
            ret = Shapes.or((VoxelShape)ret, (VoxelShape)BASE_SHAPES.get(a));
        }
        return ret;
    })));
    private final TagKey<Block> connectionTag;

    public GirderBlock(TagKey<Block> connectionTag, BlockBehaviour.Properties properties) {
        super(properties);
        this.connectionTag = connectionTag;
        this.registerDefaultState((BlockState)PROPS.keySet().stream().reduce((BlockState)this.getStateDefinition().any(), (s, a) -> (BlockState)s.setValue((Property)PROPS.get(a), (Comparable)Boolean.valueOf(false)), (s1, s2) -> s1).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add((Property[])PROPS.values().toArray(new BooleanProperty[0])).add(new Property[]{WATERLOGGED});
    }

    protected boolean propagatesSkylightDown(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (VoxelShape)((Map)this.ALL_SHAPES.get()).get(state);
    }

    @Deprecated
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean connected = false;
        for (Direction dir : Direction.values()) {
            if (!context.getLevel().getBlockState(context.getClickedPos().relative(dir)).is(this.connectionTag)) continue;
            state = (BlockState)state.setValue((Property)PROPS.get(dir.getAxis()), (Comparable)Boolean.valueOf(true));
            connected = true;
        }
        if (!connected) {
            state = (BlockState)state.setValue((Property)PROPS.get(context.getClickedFace().getAxis()), (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        BlockState ret = state;
        boolean connected = false;
        for (Direction.Axis a : Direction.Axis.values()) {
            if (level.getBlockState(pos.relative(Direction.get((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)a))).is(this.connectionTag) || level.getBlockState(pos.relative(Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)a))).is(this.connectionTag)) {
                connected = true;
                ret = (BlockState)ret.setValue((Property)PROPS.get(a), (Comparable)Boolean.valueOf(true));
                continue;
            }
            ret = (BlockState)ret.setValue((Property)PROPS.get(a), (Comparable)Boolean.valueOf(false));
        }
        if (!connected) {
            return state;
        }
        return ret;
    }
}

