/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SporeBlossomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class HoneyBlossomBlock
extends SporeBlossomBlock {
    public HoneyBlossomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        double d0 = (double)i + random.nextDouble();
        double d1 = (double)j + 0.7;
        double d2 = (double)k + random.nextDouble();
        level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_HONEY, d0, d1, d2, 0.0, 0.0, 0.0);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int l = 0; l < 14; ++l) {
            mutable.set(i + Mth.nextInt((RandomSource)random, (int)-10, (int)10), j - random.nextInt(10), k + Mth.nextInt((RandomSource)random, (int)-10, (int)10));
            BlockState blockstate = level.getBlockState((BlockPos)mutable);
            if (blockstate.isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)mutable)) continue;
            level.addParticle((ParticleOptions)ParticleTypes.FALLING_HONEY, (double)mutable.getX() + random.nextDouble(), (double)mutable.getY() + random.nextDouble(), (double)mutable.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }
}

