/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.lovetropics.extras.ExtraBlocks;
import com.lovetropics.extras.block.PapyrusStemBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class PapyrusUmbelBlock
extends Block {
    public static final EnumProperty<PapyrusStemBlock.Type> TYPE = PapyrusStemBlock.TYPE;
    public static final BooleanProperty AGEING = BooleanProperty.create((String)"ageing");
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public PapyrusUmbelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(TYPE, (Comparable)((Object)PapyrusStemBlock.Type.PLAIN))).setValue((Property)AGEING, (Comparable)Boolean.valueOf(true)));
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)AGEING);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextInt(10) == 0) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGEING, (Comparable)Boolean.valueOf(false)));
        }
        if (random.nextInt(10) == 0) {
            PapyrusStemBlock.Type type = (PapyrusStemBlock.Type)((Object)state.getValue(TYPE));
            if (type == PapyrusStemBlock.Type.PLAIN) {
                this.ageSelfAndStem(PapyrusStemBlock.Type.DRY, level, pos);
            } else if (type == PapyrusStemBlock.Type.DRY) {
                this.ageSelfAndStem(PapyrusStemBlock.Type.DEAD, level, pos);
            }
        }
    }

    private void ageSelfAndStem(PapyrusStemBlock.Type type, ServerLevel level, BlockPos pos) {
        level.setBlockAndUpdate(pos, (BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)type)));
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        for (int i = 0; i < 4; ++i) {
            mutablePos.move(Direction.DOWN);
            BlockState belowState = level.getBlockState((BlockPos)mutablePos);
            if (!belowState.is((Block)ExtraBlocks.PAPYRUS_STEM.get())) break;
            level.setBlockAndUpdate((BlockPos)mutablePos, (BlockState)belowState.setValue(PapyrusStemBlock.TYPE, (Comparable)((Object)type)));
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        return stateBelow.is((Block)ExtraBlocks.PAPYRUS_STEM.get());
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (!state.canSurvive(level, pos)) {
            scheduledTickAccess.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos().below());
        if (blockstate.is((Block)ExtraBlocks.PAPYRUS_STEM.get())) {
            return (BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)((PapyrusStemBlock.Type)((Object)blockstate.getValue(PapyrusStemBlock.TYPE)))));
        }
        return this.defaultBlockState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, AGEING});
    }
}

