/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.lovetropics.extras.entity.PrimedPlumbersTnt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class PlumbersTntBlock
extends TntBlock {
    public PlumbersTntBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void wasExploded(ServerLevel level, BlockPos pos, Explosion explosion) {
        PrimedPlumbersTnt primedtnt = PrimedPlumbersTnt.create((Level)level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, explosion.getIndirectSourceEntity());
        int fuse = primedtnt.getFuse();
        primedtnt.setFuse((short)(level.random.nextInt(fuse / 4) + fuse / 8));
        level.addFreshEntity((Entity)primedtnt);
    }

    public boolean onCaughtFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        return PlumbersTntBlock.prime(world, pos, igniter);
    }

    private static boolean prime(Level level, BlockPos pos, @Nullable LivingEntity entity) {
        if (level instanceof ServerLevel) {
            PrimedPlumbersTnt primedtnt = PrimedPlumbersTnt.create(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, entity);
            level.addFreshEntity((Entity)primedtnt);
            level.playSound(null, primedtnt.getX(), primedtnt.getY(), primedtnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent((Entity)entity, (Holder)GameEvent.PRIME_FUSE, pos);
            return true;
        }
        return false;
    }
}

